/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core;

import org.cloudbus.cloudsim.core.AbstractMachine;
import org.cloudbus.cloudsim.resources.FileStorage;
import org.cloudbus.cloudsim.vms.Vm;

public interface Machine
extends AbstractMachine<FileStorage> {
    default public double getRelativeCpuUtilization(Vm vm) {
        return this.getExpectedRelativeCpuUtilization(vm, vm.getCpuPercentUtilization());
    }

    default public double getExpectedRelativeCpuUtilization(Vm vm, double vmCpuUtilizationPercent) {
        return vmCpuUtilizationPercent * this.getRelativeMipsCapacityPercent(vm);
    }

    default public double getRelativeMipsCapacityPercent(Vm vm) {
        return vm.getTotalMipsCapacity() / this.getTotalMipsCapacity();
    }

    default public double getRelativeRamUtilization(Vm vm) {
        return (double)vm.getRam().getAllocatedResource() / (double)this.getRam().getCapacity();
    }

    default public double getRelativeBwUtilization(Vm vm) {
        return (double)vm.getBw().getAllocatedResource() / (double)this.getBw().getCapacity();
    }
}

