/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core.events;

import java.util.Objects;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudsimplus.listeners.EventInfo;
import org.cloudsimplus.listeners.EventListener;

public final class CloudSimEvent
implements SimEvent {
    private Simulation simulation;
    private final SimEvent.Type type;
    private final double time;
    private double endWaitingTime;
    private SimEntity src;
    private SimEntity dest;
    private final CloudSimTag tag;
    private final Object data;
    private long serial = -1L;

    public CloudSimEvent(double delay, SimEntity src, SimEntity dest, CloudSimTag tag, Object data) {
        this(SimEvent.Type.SEND, delay, src, dest, tag, data);
    }

    public CloudSimEvent(double delay, SimEntity dest, CloudSimTag tag) {
        this(delay, dest, tag, null);
    }

    public CloudSimEvent(SimEntity dest, CloudSimTag tag, Object data) {
        this(0.0, dest, tag, data);
    }

    public CloudSimEvent(double delay, SimEntity dest, CloudSimTag tag, Object data) {
        this(SimEvent.Type.SEND, delay, dest, dest, tag, data);
    }

    public CloudSimEvent(SimEntity dest, CloudSimTag tag) {
        this(SimEvent.Type.SEND, 0.0, dest, dest, tag, null);
    }

    public CloudSimEvent(SimEvent.Type type, double delay, SimEntity src) {
        this(type, delay, src, SimEntity.NULL, CloudSimTag.NONE, null);
    }

    public CloudSimEvent(SimEvent src) {
        this(src.getType(), src.getTime(), src.getSource(), src.getDestination(), src.getTag(), src.getData());
    }

    public CloudSimEvent(SimEvent.Type type, double delay, SimEntity src, SimEntity dest, CloudSimTag tag, Object data) {
        if (delay < 0.0) {
            throw new IllegalArgumentException("Delay can't be negative.");
        }
        this.type = type;
        this.setSource(src);
        this.setDestination(dest);
        this.setSimulation(src.getSimulation());
        this.time = this.simulation.clock() + delay;
        this.tag = tag;
        this.data = data;
    }

    @Override
    public void setSerial(long serial) {
        this.serial = serial;
    }

    @Override
    public double getEndWaitingTime() {
        return this.endWaitingTime;
    }

    @Override
    public SimEvent setSimulation(Simulation simulation) {
        this.simulation = Objects.requireNonNull(simulation);
        return this;
    }

    @Override
    public SimEvent.Type getType() {
        return this.type;
    }

    @Override
    public int compareTo(SimEvent that) {
        if (that == null || that == SimEvent.NULL) {
            return 1;
        }
        if (this == that) {
            return 0;
        }
        int res = Double.compare(this.time, that.getTime());
        if (res != 0) {
            return res;
        }
        res = this.tag.compareTo(that.getTag());
        if (res != 0) {
            return res;
        }
        return Long.compare(this.serial, that.getSerial());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CloudSimEvent that = (CloudSimEvent)obj;
        return Double.compare(that.getTime(), this.getTime()) == 0 && this.getTag() == that.getTag() && this.getSerial() == that.getSerial();
    }

    public int hashCode() {
        return Objects.hash(this.getTime(), this.getTag(), this.getSerial());
    }

    @Override
    public SimEntity getDestination() {
        return this.dest;
    }

    @Override
    public SimEntity getSource() {
        return this.src;
    }

    @Override
    public CloudSimTag getTag() {
        return this.tag;
    }

    @Override
    public int getPriority() {
        return this.tag.priority();
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public SimEvent setSource(SimEntity source) {
        this.src = Objects.requireNonNull(source);
        return this;
    }

    @Override
    public SimEvent setDestination(SimEntity destination) {
        this.dest = Objects.requireNonNull(destination);
        return this;
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public EventListener<? extends EventInfo> getListener() {
        return EventListener.NULL;
    }

    @Override
    public long getSerial() {
        return this.serial;
    }

    @Override
    public Simulation getSimulation() {
        return this.simulation;
    }

    public String toString() {
        return "Event tag = " + this.tag + " source = " + this.src.getName() + " target = " + this.dest.getName() + " time = " + this.time;
    }
}

