/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.distributions;

import org.apache.commons.math3.random.RandomGenerator;
import org.cloudbus.cloudsim.distributions.DiscreteDistribution;
import org.cloudbus.cloudsim.distributions.StatisticalDistribution;

public class ZipfDistr
implements DiscreteDistribution {
    private boolean applyAntitheticVariates;
    private final long seed;
    private final RandomGenerator rng;
    private final double shape;
    private double den;

    public ZipfDistr(double shape, int population) {
        this(shape, population, StatisticalDistribution.defaultSeed());
    }

    public ZipfDistr(double shape, int population, long seed) {
        this(shape, population, seed, StatisticalDistribution.newDefaultGen(seed));
    }

    public ZipfDistr(double shape, int population, long seed, RandomGenerator rng) {
        if (shape <= 0.0 || population < 1) {
            throw new IllegalArgumentException("Mean must be greater than 0.0 and population greater than 0");
        }
        if (seed < 0L) {
            throw new IllegalArgumentException("Seed cannot be negative");
        }
        this.rng = rng;
        this.shape = shape;
        this.seed = seed;
        this.computeDen(shape, population);
    }

    @Override
    public double sample() {
        double variate = this.rng.nextDouble();
        double num = 1.0;
        double nextNum = 1.0 + 1.0 / Math.pow(2.0, this.shape);
        double base = 3.0;
        while (variate > nextNum / this.den) {
            num = nextNum;
            nextNum += 1.0 / Math.pow(base, this.shape);
            base += 1.0;
        }
        return num / this.den;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public boolean isApplyAntitheticVariates() {
        return this.applyAntitheticVariates;
    }

    @Override
    public ZipfDistr setApplyAntitheticVariates(boolean applyAntitheticVariates) {
        this.applyAntitheticVariates = applyAntitheticVariates;
        return this;
    }

    @Override
    public double originalSample() {
        return this.rng.nextDouble();
    }

    private void computeDen(double shape, int population) {
        this.den = 0.0;
        for (int i = 1; i <= population; ++i) {
            this.den += 1.0 / Math.pow(i, shape);
        }
    }
}

