/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network;

import java.util.Objects;
import org.cloudbus.cloudsim.hosts.network.NetworkHost;
import org.cloudbus.cloudsim.network.NetworkPacket;
import org.cloudbus.cloudsim.network.VmPacket;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;

public class HostPacket
implements NetworkPacket<NetworkHost> {
    private final VmPacket vmPacket;
    private NetworkHost sourceHost;
    private NetworkHost destinationHost;
    private double sendTime;
    private double receiveTime;

    public HostPacket(NetworkHost sourceHost, VmPacket vmPacket) {
        this.vmPacket = Objects.requireNonNull(vmPacket);
        this.sendTime = vmPacket.getSendTime();
        this.setSource(sourceHost);
    }

    @Override
    public long getSize() {
        return this.vmPacket.getSize();
    }

    @Override
    public NetworkHost getSource() {
        return this.sourceHost;
    }

    @Override
    public final void setSource(NetworkHost sourceHost) {
        this.sourceHost = Objects.requireNonNull(sourceHost);
    }

    @Override
    public NetworkHost getDestination() {
        return this.destinationHost;
    }

    @Override
    public void setDestination(NetworkHost destinationHost) {
        this.destinationHost = Objects.requireNonNull(destinationHost);
    }

    @Override
    public double getSendTime() {
        return this.sendTime;
    }

    @Override
    public void setSendTime(double sendTime) {
        this.sendTime = sendTime;
    }

    @Override
    public double getReceiveTime() {
        return this.receiveTime;
    }

    @Override
    public void setReceiveTime(double receiveTime) {
        this.receiveTime = receiveTime;
    }

    public VmPacket getVmPacket() {
        return this.vmPacket;
    }

    public EdgeSwitch getVmEdgeSwitch() {
        return this.vmPacket.getDestinationHost().getEdgeSwitch();
    }
}

