/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudbus.cloudsim.core.events.PredicateType;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.hosts.network.NetworkHost;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.util.BytesConversion;
import org.cloudbus.cloudsim.vms.Vm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwitch
extends CloudSimEntity
implements Switch {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractSwitch.class.getSimpleName());
    private final Map<Switch, List<HostPacket>> uplinkSwitchPacketMap;
    private final Map<Switch, List<HostPacket>> downlinkSwitchPacketMap;
    private final Map<NetworkHost, List<HostPacket>> packetToHostMap = new HashMap<NetworkHost, List<HostPacket>>();
    private final List<Switch> uplinkSwitches;
    private final List<Switch> downlinkSwitches;
    private double uplinkBandwidth;
    private double downlinkBandwidth;
    private int ports;
    private NetworkDatacenter datacenter;
    private double switchingDelay;

    public AbstractSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation);
        this.uplinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitchPacketMap = new HashMap<Switch, List<HostPacket>>();
        this.downlinkSwitches = new ArrayList<Switch>();
        this.uplinkSwitches = new ArrayList<Switch>();
        this.datacenter = Objects.requireNonNull(dc);
    }

    @Override
    protected void startInternal() {
        LOGGER.info("{} is starting...", (Object)this.getName());
        this.schedule(CloudSimTag.DC_LIST_REQUEST);
    }

    @Override
    public void processEvent(SimEvent evt) {
        switch (evt.getTag()) {
            case NETWORK_EVENT_UP: {
                this.processPacketUp(evt);
                break;
            }
            case NETWORK_EVENT_DOWN: {
                this.processPacketDown(evt);
                break;
            }
            case NETWORK_EVENT_SEND: {
                this.processPacketForward();
                break;
            }
            case NETWORK_EVENT_HOST: {
                this.processHostPacket(evt);
                break;
            }
            default: {
                LOGGER.trace("{}: {}: Unknown event {} received.", new Object[]{this.getSimulation().clockStr(), this, evt.getTag()});
            }
        }
    }

    protected void processHostPacket(SimEvent evt) {
        Object object = evt.getData();
        if (!(object instanceof HostPacket)) {
            throw new IllegalStateException("NETWORK_EVENT_HOST SimEvent data must be a HostPacket");
        }
        HostPacket pkt = (HostPacket)object;
        NetworkHost host = pkt.getDestination();
        host.addReceivedNetworkPacket(pkt);
    }

    protected void processPacketDown(SimEvent evt) {
        this.getSimulation().cancelAll(this, new PredicateType(CloudSimTag.NETWORK_EVENT_SEND));
        this.schedule(this, this.getSwitchingDelay(), CloudSimTag.NETWORK_EVENT_SEND);
    }

    protected NetworkHost getVmHost(Vm vm) {
        return (NetworkHost)vm.getHost();
    }

    protected void processPacketUp(SimEvent evt) {
        this.getSimulation().cancelAll(this, new PredicateType(CloudSimTag.NETWORK_EVENT_SEND));
        this.schedule(this, this.switchingDelay, CloudSimTag.NETWORK_EVENT_SEND);
    }

    private void processPacketForward() {
        this.forwardPacketsToDownlinkSwitches();
        this.forwardPacketsToUplinkSwitches();
        this.forwardPacketsToHosts();
    }

    private void forwardPacketsToDownlinkSwitches() {
        for (Switch targetSwitch : this.downlinkSwitchPacketMap.keySet()) {
            List<HostPacket> hostPktList = this.getDownlinkSwitchPacketList(targetSwitch);
            double bw = this.downlinkBandwidth;
            this.forwardPacketsToSwitch(targetSwitch, hostPktList, bw, CloudSimTag.NETWORK_EVENT_DOWN);
        }
    }

    private void forwardPacketsToUplinkSwitches() {
        for (Switch targetSwitch : this.uplinkSwitchPacketMap.keySet()) {
            List<HostPacket> hostPktList = this.getUplinkSwitchPacketList(targetSwitch);
            double bw = this.uplinkBandwidth;
            this.forwardPacketsToSwitch(targetSwitch, hostPktList, bw, CloudSimTag.NETWORK_EVENT_UP);
        }
    }

    private void forwardPacketsToSwitch(Switch destinationSwitch, List<HostPacket> packetList, double bandwidth, CloudSimTag tag) {
        for (HostPacket pkt : packetList) {
            double delay = this.packetTransferDelay(pkt, bandwidth, packetList.size());
            this.send(destinationSwitch, delay, tag, pkt);
        }
        packetList.clear();
    }

    private void forwardPacketsToHosts() {
        for (NetworkHost host : this.packetToHostMap.keySet()) {
            List<HostPacket> hostPktList = this.getHostPacketList(host);
            this.forwardPacketsToSwitch(this, hostPktList, this.downlinkBandwidth, CloudSimTag.NETWORK_EVENT_HOST);
        }
    }

    @Override
    public double downlinkTransferDelay(HostPacket packet, int simultaneousPackets) {
        return this.packetTransferDelay(packet, this.downlinkBandwidth, simultaneousPackets);
    }

    @Override
    public double uplinkTransferDelay(HostPacket packet, int simultaneousPackets) {
        return this.packetTransferDelay(packet, this.uplinkBandwidth, simultaneousPackets);
    }

    protected double packetTransferDelay(HostPacket netPkt, double bwCapacity, int simultaneousPackets) {
        return BytesConversion.bytesToMegaBits(netPkt.getSize()) / this.bandwidthByPacket(bwCapacity, simultaneousPackets);
    }

    protected double bandwidthByPacket(double bwCapacity, int simultaneousPackets) {
        return simultaneousPackets == 0 ? bwCapacity : bwCapacity / (double)simultaneousPackets;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        LOGGER.info("{} is shutting down...", (Object)this.getName());
    }

    @Override
    public double getUplinkBandwidth() {
        return this.uplinkBandwidth;
    }

    @Override
    public final void setUplinkBandwidth(double uplinkBandwidth) {
        this.uplinkBandwidth = uplinkBandwidth;
    }

    @Override
    public double getDownlinkBandwidth() {
        return this.downlinkBandwidth;
    }

    @Override
    public final void setDownlinkBandwidth(double downlinkBandwidth) {
        this.downlinkBandwidth = downlinkBandwidth;
    }

    @Override
    public int getPorts() {
        return this.ports;
    }

    @Override
    public final void setPorts(int ports) {
        this.ports = ports;
    }

    @Override
    public double getSwitchingDelay() {
        return this.switchingDelay;
    }

    @Override
    public final void setSwitchingDelay(double switchingDelay) {
        this.switchingDelay = switchingDelay;
    }

    @Override
    public List<Switch> getUplinkSwitches() {
        return this.uplinkSwitches;
    }

    @Override
    public List<Switch> getDownlinkSwitches() {
        return this.downlinkSwitches;
    }

    protected List<HostPacket> getDownlinkSwitchPacketList(Switch downlinkSwitch) {
        return this.downlinkSwitchPacketMap.getOrDefault(downlinkSwitch, new ArrayList());
    }

    protected List<HostPacket> getUplinkSwitchPacketList(Switch uplinkSwitch) {
        return this.uplinkSwitchPacketMap.getOrDefault(uplinkSwitch, new ArrayList());
    }

    protected List<HostPacket> getHostPacketList(NetworkHost host) {
        return this.packetToHostMap.getOrDefault(host, new ArrayList());
    }

    protected void addPacketToSendToDownlinkSwitch(Switch downlinkSwitch, HostPacket packet) {
        this.computeMapValue(this.downlinkSwitchPacketMap, downlinkSwitch, packet);
    }

    protected void addPacketToBeSentToFirstUplinkSwitch(HostPacket netPkt) {
        Switch uplinkSw = this.getUplinkSwitches().get(0);
        this.addPacketToSendToUplinkSwitch(uplinkSw, netPkt);
    }

    protected void addPacketToSendToUplinkSwitch(Switch uplinkSwitch, HostPacket packet) {
        this.computeMapValue(this.uplinkSwitchPacketMap, uplinkSwitch, packet);
    }

    protected void addPacketToSendToHost(NetworkHost host, HostPacket packet) {
        this.computeMapValue(this.packetToHostMap, host, packet);
    }

    private <K, V> void computeMapValue(Map<K, List<V>> map, K key, V valueToAdd) {
        map.compute(key, (k, list) -> list == null ? new ArrayList() : list).add(valueToAdd);
    }

    @Override
    public NetworkDatacenter getDatacenter() {
        return this.datacenter;
    }

    @Override
    public void setDatacenter(NetworkDatacenter datacenter) {
        this.datacenter = datacenter;
    }
}

