/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies.readers;

import org.cloudbus.cloudsim.network.topologies.Point2D;
import org.cloudbus.cloudsim.network.topologies.TopologicalLink;
import org.cloudbus.cloudsim.network.topologies.TopologicalNode;
import org.cloudbus.cloudsim.network.topologies.readers.TopologyReaderBrite;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ParsingState {
    NOTHING{

        @Override
        void parse(TopologyReaderBrite reader, String line) {
            if (line.contains("Nodes:")) {
                reader.setState(NODES);
            }
        }
    }
    ,
    NODES{

        @Override
        void parse(TopologyReaderBrite reader, String line) {
            if (line.contains("Edges:")) {
                reader.setState(EDGES);
                return;
            }
            Number[] parsedFields = new Integer[]{0, 0, 0};
            if (!reader.parseLine(line, parsedFields, Integer::valueOf)) {
                return;
            }
            Point2D coordinates = new Point2D((Integer)parsedFields[1], (Integer)parsedFields[2]);
            TopologicalNode topoNode = new TopologicalNode((Integer)parsedFields[0], coordinates);
            reader.getGraph().addNode(topoNode);
        }
    }
    ,
    EDGES{

        @Override
        void parse(TopologyReaderBrite reader, String line) {
            Number[] parsedFields = new Double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            if (!reader.parseLine(line, parsedFields, Double::valueOf)) {
                return;
            }
            int fromNode = ((Double)parsedFields[1]).intValue();
            int toNode = ((Double)parsedFields[2]).intValue();
            double linkDelay = (Double)parsedFields[4];
            double linkBandwidth = (Double)parsedFields[5];
            reader.getGraph().addLink(new TopologicalLink(fromNode, toNode, linkDelay, linkBandwidth));
        }
    };


    abstract void parse(TopologyReaderBrite var1, String var2);
}

