/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power;

import java.util.Objects;

public class PowerMeasurement {
    private final double staticPower;
    private final double dynamicPower;

    public PowerMeasurement(double staticPower, double dynamicPower) {
        this.staticPower = staticPower;
        this.dynamicPower = dynamicPower;
    }

    public PowerMeasurement() {
        this(0.0, 0.0);
    }

    public double getTotalPower() {
        return this.staticPower + this.dynamicPower;
    }

    public double getStaticPower() {
        return this.staticPower;
    }

    public double getDynamicPower() {
        return this.dynamicPower;
    }

    public PowerMeasurement add(PowerMeasurement measurement) {
        Objects.requireNonNull(measurement, "measurement cannot be null");
        return new PowerMeasurement(this.staticPower + measurement.getStaticPower(), this.dynamicPower + measurement.getDynamicPower());
    }

    public PowerMeasurement multiply(double factor) {
        return new PowerMeasurement(this.staticPower * factor, this.dynamicPower * factor);
    }
}

