/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.power.models;

import java.util.List;
import java.util.Objects;
import org.cloudbus.cloudsim.power.PowerMeasurement;
import org.cloudbus.cloudsim.power.models.PowerModelHost;

public class PowerModelHostSpec
extends PowerModelHost {
    public static final int MIN_POWER_CONSUMPTION_DATA_SIZE = 2;
    private final List<Double> powerSpec;

    public PowerModelHostSpec(List<Double> powerSpec) {
        Objects.requireNonNull(powerSpec, "powerSpec cannot be null");
        if (powerSpec.size() >= 2) {
            this.powerSpec = powerSpec;
            return;
        }
        String msg = String.format("powerSpec has to contain at least %d elements (representing utilization at 0%% and 100%% load, respectively)", 2);
        throw new IllegalArgumentException(msg);
    }

    @Override
    public PowerMeasurement getPowerMeasurement() {
        double utilizationFraction = this.getHost().getCpuMipsUtilization() / this.getHost().getTotalMipsCapacity();
        int utilizationIndex = (int)Math.round(utilizationFraction * (double)this.powerSpec.size());
        double powerUsage = this.powerSpec.get(utilizationIndex);
        return new PowerMeasurement(this.powerSpec.get(0), powerUsage - this.powerSpec.get(0));
    }

    @Override
    public double getPower(double utilizationFraction) throws IllegalArgumentException {
        int utilizationIndex = (int)Math.round(utilizationFraction * (double)this.powerSpec.size());
        return this.powerSpec.get(utilizationIndex);
    }
}

