/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.provisioners;

import java.util.Objects;
import org.cloudbus.cloudsim.provisioners.PeProvisioner;
import org.cloudbus.cloudsim.provisioners.ResourceProvisionerSimple;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;

public class PeProvisionerSimple
extends ResourceProvisionerSimple
implements PeProvisioner {
    public PeProvisionerSimple() {
        super(Pe.NULL, vm -> ResourceManageable.NULL);
    }

    public PeProvisionerSimple(Pe pe) {
        super(pe, Vm::getProcessor);
        pe.setPeProvisioner(this);
    }

    @Override
    public void setPe(Pe pe) {
        if (this.isOtherProvisionerAssignedToPe(pe)) {
            throw new IllegalArgumentException("Pe already has a PeProvisioner assigned to it. Each Pe must have its own PeProvisioner instance.");
        }
        this.setResources(pe, Vm::getProcessor);
    }

    @Override
    public double getUtilization() {
        return (double)this.getTotalAllocatedResource() / (double)this.getCapacity();
    }

    private boolean isOtherProvisionerAssignedToPe(Pe pe) {
        Objects.requireNonNull(pe);
        return pe.getPeProvisioner() != null && pe.getPeProvisioner() != PeProvisioner.NULL && !pe.getPeProvisioner().equals(this);
    }
}

