/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import java.util.Objects;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.resources.FileAttribute;

public class File {
    public static final int NOT_REGISTERED = -1;
    public static final int TYPE_UNKNOWN = 0;
    private String name;
    private Datacenter datacenter;
    private FileAttribute attribute;
    private double transactionTime;
    private boolean deleted;

    public File(String fileName, int fileSize) {
        if (fileSize <= 0) {
            throw new IllegalArgumentException("File(): Error - size <= 0.");
        }
        this.datacenter = Datacenter.NULL;
        this.setName(fileName);
        this.transactionTime = 0.0;
        this.createAttribute(fileSize);
    }

    public File(File file) throws IllegalArgumentException {
        this(Objects.requireNonNull(file), false);
    }

    protected File(File file, boolean masterCopy) throws IllegalArgumentException {
        this(file.getName(), file.getSize());
        this.setDatacenter(file.getDatacenter());
        this.deleted = file.deleted;
        file.getAttribute().copyValue(this.attribute);
        this.attribute.setMasterCopy(masterCopy);
    }

    public static void validate(File file) {
        Objects.requireNonNull(file, "Given file cannot be null.");
        File.validateFileName(file.getName());
    }

    public static String validateFileName(String fileName) {
        Objects.requireNonNull(fileName, "File name cannot be null.");
        if (fileName.isBlank()) {
            throw new IllegalArgumentException("File name cannot be blank");
        }
        return fileName;
    }

    protected void createAttribute(int fileSize) {
        this.attribute = new FileAttribute(this, fileSize);
    }

    public File makeReplica() {
        return this.makeCopy();
    }

    public File makeMasterCopy() {
        return this.makeCopy().setMasterCopy(true);
    }

    private File makeCopy() {
        File file = new File(this.name, this.attribute.getFileSize());
        this.attribute.copyValue(file.attribute);
        file.attribute.setMasterCopy(false);
        return file;
    }

    public FileAttribute getAttribute() {
        return this.attribute;
    }

    protected void setAttribute(FileAttribute attribute) {
        this.attribute = attribute;
    }

    public int getAttributeSize() {
        return this.attribute.getAttributeSize();
    }

    public String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = File.validateFileName(name);
    }

    public boolean setOwnerName(String name) {
        return this.attribute.setOwnerName(name);
    }

    public String getOwnerName() {
        return this.attribute.getOwnerName();
    }

    public int getSize() {
        return this.attribute.getFileSize();
    }

    public int getSizeInByte() {
        return this.attribute.getFileSizeInByte();
    }

    public boolean setSize(int fileSize) {
        return this.attribute.setFileSize(fileSize);
    }

    public boolean setUpdateTime(double time) {
        return this.attribute.setUpdateTime(time);
    }

    public double getLastUpdateTime() {
        return this.attribute.getLastUpdateTime();
    }

    public boolean setRegistrationID(int id) {
        return this.attribute.setRegistrationId(id);
    }

    public long getRegistrationID() {
        return this.attribute.getRegistrationID();
    }

    public boolean setType(int type) {
        return this.attribute.setType(type);
    }

    public int getType() {
        return this.attribute.getType();
    }

    public boolean setChecksum(int checksum) {
        return this.attribute.setChecksum(checksum);
    }

    public int getChecksum() {
        return this.attribute.getChecksum();
    }

    public boolean setCost(double cost) {
        return this.attribute.setCost(cost);
    }

    public double getCost() {
        return this.attribute.getCost();
    }

    public long getCreationTime() {
        return this.attribute.getCreationTime();
    }

    public boolean isRegistered() {
        return this.attribute.isRegistered();
    }

    public boolean isMasterCopy() {
        return this.attribute.isMasterCopy();
    }

    public File setMasterCopy(boolean masterCopy) {
        this.attribute.setMasterCopy(masterCopy);
        return this;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean setTransactionTime(double time) {
        if (time < 0.0) {
            return false;
        }
        this.transactionTime = time;
        return true;
    }

    public double getTransactionTime() {
        return this.transactionTime;
    }

    public String toString() {
        return this.getName();
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    public final File setDatacenter(Datacenter datacenter) {
        this.datacenter = Objects.requireNonNull(datacenter);
        return this;
    }
}

