/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import org.cloudbus.cloudsim.resources.ResourceManageableAbstract;
import org.cloudbus.cloudsim.vms.Vm;

public final class Processor
extends ResourceManageableAbstract {
    public static final Processor NULL = new Processor(0L);
    private Vm vm;
    private double mips;

    public Processor(Vm vm, double pesMips, long numberOfPes) {
        this(numberOfPes);
        this.vm = vm;
        this.setMips(pesMips);
    }

    private Processor(long numberOfPes) {
        super(numberOfPes, "Unit");
    }

    public double getTotalMips() {
        return this.getMips() * (double)this.getCapacity();
    }

    public double getMips() {
        return this.mips;
    }

    public void setMips(double newMips) {
        if (newMips < 0.0) {
            throw new IllegalArgumentException("MIPS cannot be negative");
        }
        this.mips = newMips;
    }

    @Override
    public long getCapacity() {
        return super.getCapacity();
    }

    @Override
    public long getAvailableResource() {
        return super.getAvailableResource();
    }

    @Override
    public long getAllocatedResource() {
        return super.getAllocatedResource();
    }

    @Override
    public boolean setCapacity(long numberOfPes) {
        if (numberOfPes <= 0L) {
            throw new IllegalArgumentException("The Processor's number of PEs must be greater than 0.");
        }
        return super.setCapacity(numberOfPes);
    }

    public Vm getVm() {
        return this.vm;
    }
}

