/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import org.apache.commons.lang3.StringUtils;
import org.cloudbus.cloudsim.resources.Resource;

public abstract class ResourceAbstract
implements Resource {
    protected long capacity;
    private final String unit;

    public ResourceAbstract(long capacity, String unit) {
        this.capacity = this.validateCapacity(capacity);
        if (unit == null || StringUtils.isBlank((CharSequence)unit)) {
            throw new IllegalArgumentException("Resource measurement unit cannot be null or empty");
        }
        this.unit = unit;
    }

    private long validateCapacity(long capacity) {
        if (capacity < 0L) {
            throw new IllegalArgumentException("Capacity cannot be negative");
        }
        return capacity;
    }

    @Override
    public long getCapacity() {
        return this.capacity;
    }

    @Override
    public long getAllocatedResource() {
        return this.getCapacity() - this.getAvailableResource();
    }

    @Override
    public boolean isAmountAvailable(long amountToCheck) {
        return this.getAvailableResource() >= amountToCheck;
    }

    @Override
    public boolean isAmountAvailable(double amountToCheck) {
        return this.isAmountAvailable((long)amountToCheck);
    }

    public boolean isResourceAmountBeingUsed(long amountToCheck) {
        return this.getAllocatedResource() >= amountToCheck;
    }

    public boolean isSuitable(long newTotalAllocatedResource) {
        if (newTotalAllocatedResource <= this.getAllocatedResource()) {
            return true;
        }
        long allocationDifference = newTotalAllocatedResource - this.getAllocatedResource();
        return this.isAmountAvailable(allocationDifference);
    }

    @Override
    public String getUnit() {
        return this.unit;
    }
}

