/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSelectionPolicyMinimumMigrationTime
implements VmSelectionPolicy {
    @Override
    public Optional<Vm> getVmToMigrate(Host host) {
        List<Vm> migratableVms = host.getMigratableVms();
        if (migratableVms.isEmpty()) {
            return Optional.empty();
        }
        Comparator<Vm> vmComparator = Comparator.comparingLong(vm -> vm.getRam().getCapacity());
        Predicate<Vm> vmPredicate = Vm::isInMigration;
        return migratableVms.stream().filter(vmPredicate.negate()).min(vmComparator);
    }
}

