/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms;

public class VmStateHistoryEntry {
    private double time;
    private double allocatedMips;
    private double requestedMips;
    private boolean inMigration;

    public VmStateHistoryEntry(double time, double allocatedMips, double requestedMips, boolean inMigration) {
        this.setTime(time);
        this.setAllocatedMips(allocatedMips);
        this.setRequestedMips(requestedMips);
        this.setInMigration(inMigration);
    }

    protected final void setTime(double time) {
        this.time = time;
    }

    public double getTime() {
        return this.time;
    }

    protected final void setAllocatedMips(double allocatedMips) {
        this.allocatedMips = allocatedMips;
    }

    public double getAllocatedMips() {
        return this.allocatedMips;
    }

    protected final void setRequestedMips(double requestedMips) {
        this.requestedMips = requestedMips;
    }

    public double getRequestedMips() {
        return this.requestedMips;
    }

    protected final void setInMigration(boolean inMigration) {
        this.inMigration = inMigration;
    }

    public boolean isInMigration() {
        return this.inMigration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof VmStateHistoryEntry)) return false;
        VmStateHistoryEntry that = (VmStateHistoryEntry)obj;
        if (that.time != this.time) return false;
        if (that.inMigration != this.inMigration) return false;
        if (that.allocatedMips != this.allocatedMips) return false;
        if (that.requestedMips != this.requestedMips) return false;
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = this.hash(hash, this.toBits(this.time));
        hash = this.hash(hash, this.toBits(this.allocatedMips));
        hash = this.hash(hash, this.toBits(this.requestedMips));
        hash = this.hash(hash, this.inMigration ? 1 : 0);
        return hash;
    }

    private int hash(int hash, int value) {
        return 89 * hash + value;
    }

    private int toBits(double value) {
        return (int)(Double.doubleToLongBits(value) ^ Double.doubleToLongBits(value) >>> 32);
    }
}

