/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.cloudlets.CloudletSimple;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModel;
import org.cloudbus.cloudsim.utilizationmodels.UtilizationModelFull;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.builders.BrokerBuilderDecorator;
import org.cloudsimplus.builders.Builder;
import org.cloudsimplus.listeners.CloudletVmEventInfo;
import org.cloudsimplus.listeners.EventListener;

public class CloudletBuilder
implements Builder {
    private long length = 10000L;
    private long outputSize = 300L;
    private long fileSize = 300L;
    private int pes = 1;
    private Vm vm = Vm.NULL;
    private UtilizationModel utilizationModelRam;
    private UtilizationModel utilizationModelCpu;
    private UtilizationModel utilizationModelBw;
    private final List<Cloudlet> cloudlets;
    private int createdCloudlets;
    private final BrokerBuilderDecorator brokerBuilder;
    private final DatacenterBrokerSimple broker;
    private BiFunction<Long, Integer, Cloudlet> cloudletCreationFunction;
    private EventListener<CloudletVmEventInfo> onCloudletFinishListener = EventListener.NULL;
    private List<String> requiredFiles;

    public CloudletBuilder(BrokerBuilderDecorator brokerBuilder, DatacenterBrokerSimple broker) {
        this.brokerBuilder = Objects.requireNonNull(brokerBuilder);
        this.broker = Objects.requireNonNull(broker);
        this.setUtilizationModelCpuRamAndBw(new UtilizationModelFull());
        this.cloudlets = new ArrayList<Cloudlet>();
        this.requiredFiles = new ArrayList<String>();
        this.createdCloudlets = 0;
        this.cloudletCreationFunction = this::defaultCloudletCreationFunction;
    }

    public CloudletBuilder create(int amount, int initialId) {
        this.createCloudletsInternal(amount, initialId);
        return this;
    }

    public CloudletBuilder create(int amount) {
        this.createCloudletsInternal(amount, 0);
        return this;
    }

    public CloudletBuilder createAndSubmit(int amount) {
        return this.createAndSubmit(amount, 0);
    }

    public CloudletBuilder createAndSubmit(int amount, int initialId) {
        List<Cloudlet> localList = this.createCloudletsInternal(amount, initialId);
        if (this.vm != Vm.NULL) {
            localList.forEach(cloudlet -> this.broker.bindCloudletToVm((Cloudlet)cloudlet, this.vm));
        }
        this.broker.submitCloudletList(localList);
        return this;
    }

    private List<Cloudlet> createCloudletsInternal(int amount, int initialId) {
        ArrayList<Cloudlet> localList = new ArrayList<Cloudlet>();
        for (int i = 0; i < amount; ++i) {
            int cloudletId = initialId + this.createdCloudlets++;
            Cloudlet cloudlet = this.cloudletCreationFunction.apply(this.length, this.pes).setFileSize(this.fileSize).setOutputSize(this.outputSize).setUtilizationModelCpu(this.utilizationModelCpu).setUtilizationModelRam(this.utilizationModelRam).setUtilizationModelBw(this.utilizationModelBw).addOnFinishListener(this.onCloudletFinishListener);
            cloudlet.setId(cloudletId);
            cloudlet.setBroker(this.broker);
            cloudlet.addRequiredFiles(this.requiredFiles);
            localList.add(cloudlet);
        }
        this.cloudlets.addAll(localList);
        return localList;
    }

    private Cloudlet defaultCloudletCreationFunction(long length, int pes) {
        return new CloudletSimple(length, pes);
    }

    public CloudletBuilder submitCloudlets() {
        this.broker.submitCloudletList(this.cloudlets);
        return this;
    }

    public final CloudletBuilder setUtilizationModelCpuRamAndBw(UtilizationModel utilizationModel) {
        Objects.requireNonNull(utilizationModel);
        this.utilizationModelCpu = utilizationModel;
        this.utilizationModelRam = utilizationModel;
        this.utilizationModelBw = utilizationModel;
        return this;
    }

    public CloudletBuilder setVm(Vm defaultVm) {
        this.vm = defaultVm;
        return this;
    }

    public CloudletBuilder setFileSize(long defaultFileSize) {
        this.fileSize = defaultFileSize;
        return this;
    }

    public CloudletBuilder setRequiredFiles(List<String> requiredFiles) {
        this.requiredFiles = requiredFiles;
        return this;
    }

    public List<Cloudlet> getCloudlets() {
        return this.cloudlets;
    }

    public CloudletBuilder setPEs(int defaultPEs) {
        this.pes = defaultPEs;
        return this;
    }

    public long getLength() {
        return this.length;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public long getOutputSize() {
        return this.outputSize;
    }

    public CloudletBuilder setOutputSize(long defaultOutputSize) {
        this.outputSize = defaultOutputSize;
        return this;
    }

    public int getPes() {
        return this.pes;
    }

    public CloudletBuilder setLength(long defaultLength) {
        this.length = defaultLength;
        return this;
    }

    public BrokerBuilderDecorator getBrokerBuilder() {
        return this.brokerBuilder;
    }

    public CloudletBuilder setOnCloudletFinishListener(EventListener<CloudletVmEventInfo> listener) {
        this.onCloudletFinishListener = listener;
        return this;
    }

    public CloudletBuilder setUtilizationModelRam(UtilizationModel utilizationModelRam) {
        this.utilizationModelRam = Objects.requireNonNull(utilizationModelRam);
        return this;
    }

    public CloudletBuilder setUtilizationModelCpu(UtilizationModel utilizationModelCpu) {
        this.utilizationModelCpu = Objects.requireNonNull(utilizationModelCpu);
        return this;
    }

    public CloudletBuilder setUtilizationModelBw(UtilizationModel utilizationModelBw) {
        this.utilizationModelBw = Objects.requireNonNull(utilizationModelBw);
        return this;
    }

    public void setCloudletCreationFunction(BiFunction<Long, Integer, Cloudlet> cloudletCreationFunction) {
        this.cloudletCreationFunction = Objects.requireNonNull(cloudletCreationFunction);
    }
}

