/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.Table;
import org.cloudsimplus.builders.tables.TableColumn;

public abstract class AbstractTableColumn
implements TableColumn {
    private String title;
    private String subTitle;
    private String format;
    private Table table;

    public AbstractTableColumn(Table table, String title) {
        this(table, title, "");
    }

    public AbstractTableColumn(String title, String subTitle) {
        this(null, title, subTitle);
    }

    public AbstractTableColumn(Table table, String title, String subTitle) {
        this.table = table;
        this.title = title;
        this.setFormat("");
        this.subTitle = subTitle;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public AbstractTableColumn setTitle(String title) {
        this.title = title;
        return this;
    }

    @Override
    public String getSubTitle() {
        return this.subTitle;
    }

    @Override
    public AbstractTableColumn setSubTitle(String subTitle) {
        this.subTitle = subTitle;
        return this;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public final AbstractTableColumn setFormat(String format) {
        this.format = format;
        return this;
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public AbstractTableColumn setTable(Table table) {
        this.table = table;
        return this;
    }

    @Override
    public String generateData(Object data) {
        if (StringUtils.isBlank((CharSequence)this.format)) {
            return String.valueOf(data);
        }
        return String.format(this.format, data);
    }

    protected abstract String generateHeader(String var1);

    @Override
    public String generateTitleHeader() {
        return this.generateHeader(this.title);
    }

    @Override
    public String generateSubtitleHeader() {
        return this.generateHeader(this.subTitle);
    }

    protected int getIndex() {
        return this.table.getColumns().indexOf(this);
    }

    protected boolean isLastColumn() {
        return this.getIndex() == this.getTable().getColumns().size() - 1;
    }
}

