/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.AbstractTable;
import org.cloudsimplus.builders.tables.CsvTableColumn;
import org.cloudsimplus.builders.tables.TableColumn;

public class CsvTable
extends AbstractTable {
    public CsvTable() {
        this("");
    }

    public CsvTable(String title) {
        super(title);
        this.setColumnSeparator(";");
    }

    @Override
    public void printTitle() {
    }

    @Override
    public void printTableOpening() {
    }

    @Override
    public void printTableClosing() {
    }

    @Override
    protected String rowOpening() {
        return "";
    }

    @Override
    protected String rowClosing() {
        return "%n";
    }

    @Override
    protected String subtitleHeaderOpening() {
        return "";
    }

    protected String createHorizontalLine(boolean includeColSeparator) {
        if (includeColSeparator) {
            StringBuilder sb = new StringBuilder(this.rowOpening());
            String row = this.getColumns().stream().map(col -> this.stringRepeat(this.getLineSeparator(), col.getTitle().length())).collect(Collectors.joining(this.getColumnSeparator()));
            return sb.append(row).append(this.rowClosing()).toString();
        }
        return this.stringRepeat(this.getLineSeparator(), this.getLengthOfColumnHeadersRow()) + "%n";
    }

    protected final String stringRepeat(String str, int timesToRepeat) {
        return new String(new char[timesToRepeat]).replace("\u0000", str);
    }

    protected final int getLengthOfColumnHeadersRow() {
        return this.getColumns().stream().mapToInt(col -> col.generateTitleHeader().length()).sum();
    }

    protected String getCentralizedString(String str) {
        int indentationLength = (this.getLengthOfColumnHeadersRow() - str.length()) / 2;
        return String.format("%n%s%s%n", StringUtils.repeat((String)" ", (int)indentationLength), str);
    }

    public String getLineSeparator() {
        return "";
    }

    @Override
    public TableColumn addColumn(int index, String columnTitle) {
        CsvTableColumn col = new CsvTableColumn(this, columnTitle);
        this.getColumns().add(index, col);
        return col;
    }
}

