/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.CsvTable;
import org.cloudsimplus.builders.tables.MarkdownTableColumn;
import org.cloudsimplus.builders.tables.TableColumn;

public class MarkdownTable
extends CsvTable {
    public MarkdownTable() {
        this("");
    }

    public MarkdownTable(String title) {
        super(title);
        this.setColumnSeparator("|");
    }

    @Override
    protected String rowOpening() {
        return this.getColumnSeparator();
    }

    @Override
    public void printTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.getTitle())) {
            this.getPrintStream().println(this.getCentralizedString(this.getTitle()));
        }
    }

    @Override
    public void printTableOpening() {
        this.getPrintStream().println();
    }

    @Override
    protected String subtitleHeaderOpening() {
        return this.createHorizontalLine(true);
    }

    @Override
    public void printTableClosing() {
    }

    @Override
    public String getLineSeparator() {
        return "-";
    }

    @Override
    public TableColumn addColumn(int index, String columnTitle) {
        return this.addColumn(new MarkdownTableColumn(this, columnTitle));
    }
}

