/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.apache.commons.lang3.StringUtils;
import org.cloudsimplus.builders.tables.CsvTable;
import org.cloudsimplus.builders.tables.TableColumn;
import org.cloudsimplus.builders.tables.TextTableColumn;

public class TextTable
extends CsvTable {
    public TextTable() {
        this("");
    }

    public TextTable(String title) {
        super(title);
        this.setColumnSeparator("|");
    }

    @Override
    public void printTitle() {
        if (StringUtils.isNotBlank((CharSequence)this.getTitle())) {
            this.getPrintStream().println(this.getCentralizedString(this.getTitle()));
        }
    }

    @Override
    public void printTableOpening() {
        this.getPrintStream().println();
    }

    @Override
    protected void printColumnHeaders() {
        super.printColumnHeaders();
        this.getPrintStream().printf(this.createHorizontalLine(false), new Object[0]);
    }

    @Override
    public void printTableClosing() {
        this.getPrintStream().printf(this.createHorizontalLine(false), new Object[0]);
    }

    @Override
    public String getLineSeparator() {
        return "-";
    }

    @Override
    public TableColumn addColumn(int index, String columnTitle) {
        return this.addColumn(new TextTableColumn(this, columnTitle));
    }
}

