/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.faultinjection;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.faultinjection.VmCloner;

public class VmClonerSimple
implements VmCloner {
    private UnaryOperator<Vm> vmClonerFunction;
    private Function<Vm, List<Cloudlet>> cloudletsClonerFunction;
    private int maxClonesNumber = 1;
    private int clonedVmsNumber;

    public VmClonerSimple(UnaryOperator<Vm> vmClonerFunction, Function<Vm, List<Cloudlet>> cloudletsClonerFunction) {
        this.setVmClonerFunction(vmClonerFunction);
        this.setCloudletsClonerFunction(cloudletsClonerFunction);
    }

    @Override
    public int getClonedVmsNumber() {
        return this.clonedVmsNumber;
    }

    @Override
    public Map.Entry<Vm, List<Cloudlet>> clone(Vm sourceVm) {
        Vm clonedVm = (Vm)this.vmClonerFunction.apply(Objects.requireNonNull(sourceVm));
        List<Cloudlet> clonedCloudletList = this.cloudletsClonerFunction.apply(sourceVm);
        if (clonedCloudletList.isEmpty()) {
            LOGGER.warn("{}: {}: There was no Cloudlet from {} in {} to clone.", new Object[]{sourceVm.getSimulation().clockStr(), this.getClass().getSimpleName(), sourceVm, sourceVm.getBroker()});
        }
        clonedCloudletList.forEach(cloudlet -> cloudlet.setVm(clonedVm));
        ++this.clonedVmsNumber;
        return new AbstractMap.SimpleEntry<Vm, List<Cloudlet>>(clonedVm, clonedCloudletList);
    }

    @Override
    public final VmCloner setVmClonerFunction(UnaryOperator<Vm> vmClonerFunction) {
        this.vmClonerFunction = Objects.requireNonNull(vmClonerFunction);
        return this;
    }

    @Override
    public final VmCloner setCloudletsClonerFunction(Function<Vm, List<Cloudlet>> cloudletsClonerFunction) {
        this.cloudletsClonerFunction = Objects.requireNonNull(cloudletsClonerFunction);
        return this;
    }

    @Override
    public int getMaxClonesNumber() {
        return this.maxClonesNumber;
    }

    @Override
    public boolean isMaxClonesNumberReached() {
        return this.clonedVmsNumber >= this.maxClonesNumber;
    }

    @Override
    public VmCloner setMaxClonesNumber(int maxClonesNumber) {
        this.maxClonesNumber = maxClonesNumber;
        return this;
    }
}

