/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.heuristics;

import java.util.List;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.heuristics.CloudletToVmMappingHeuristic;
import org.cloudsimplus.heuristics.CloudletToVmMappingSolution;
import org.cloudsimplus.heuristics.SimulatedAnnealingAbstract;

public class CloudletToVmMappingSimulatedAnnealing
extends SimulatedAnnealingAbstract<CloudletToVmMappingSolution>
implements CloudletToVmMappingHeuristic {
    private CloudletToVmMappingSolution initialSolution;
    private List<Vm> vmList;
    private List<Cloudlet> cloudletList;

    public CloudletToVmMappingSimulatedAnnealing(double initialTemperature, ContinuousDistribution random) {
        super(random, CloudletToVmMappingSolution.class);
        this.setCurrentTemperature(initialTemperature);
        this.initialSolution = new CloudletToVmMappingSolution(this);
    }

    private CloudletToVmMappingSolution generateRandomSolution() {
        CloudletToVmMappingSolution solution = new CloudletToVmMappingSolution(this);
        this.cloudletList.forEach(cloudlet -> solution.bindCloudletToVm((Cloudlet)cloudlet, this.getRandomVm()));
        return solution;
    }

    private boolean isReadToGenerateInitialSolution() {
        return !this.cloudletList.isEmpty() && !this.vmList.isEmpty();
    }

    private boolean isThereInitialSolution() {
        return !this.initialSolution.getResult().isEmpty();
    }

    @Override
    public CloudletToVmMappingSolution getInitialSolution() {
        if (!this.isThereInitialSolution() && this.isReadToGenerateInitialSolution()) {
            this.initialSolution = this.generateRandomSolution();
        }
        return this.initialSolution;
    }

    @Override
    public List<Vm> getVmList() {
        return this.vmList;
    }

    @Override
    public void setVmList(List<Vm> vmList) {
        this.vmList = vmList;
    }

    @Override
    public List<Cloudlet> getCloudletList() {
        return this.cloudletList;
    }

    @Override
    public void setCloudletList(List<Cloudlet> cloudletList) {
        this.cloudletList = cloudletList;
    }

    private Vm getRandomVm() {
        int idx = this.getRandomValue(this.vmList.size());
        return this.vmList.get(idx);
    }

    @Override
    public CloudletToVmMappingSolution createNeighbor(CloudletToVmMappingSolution source) {
        CloudletToVmMappingSolution clone = new CloudletToVmMappingSolution(source);
        clone.swapVmsOfTwoRandomSelectedMapEntries();
        return clone;
    }
}

