/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.listeners;

import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.HostSuitability;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;

public final class DatacenterVmMigrationEventInfo
implements VmDatacenterEventInfo {
    private final double time;
    private final Vm vm;
    private final HostSuitability suitability;
    private final EventListener<DatacenterVmMigrationEventInfo> listener;

    private DatacenterVmMigrationEventInfo(Vm vm, HostSuitability suitability, EventListener<DatacenterVmMigrationEventInfo> listener) {
        this.vm = vm;
        this.time = vm.getSimulation().clock();
        this.suitability = suitability;
        this.listener = listener;
    }

    @Override
    public Vm getVm() {
        return this.vm;
    }

    @Override
    public Datacenter getDatacenter() {
        return this.vm.getHost().getDatacenter();
    }

    @Override
    public double getTime() {
        return this.time;
    }

    public boolean isMigrationSuccessful() {
        return this.suitability.fully();
    }

    public HostSuitability getHostSuitability() {
        return this.suitability;
    }

    public EventListener<DatacenterVmMigrationEventInfo> getListener() {
        return this.listener;
    }

    public static DatacenterVmMigrationEventInfo of(EventListener<DatacenterVmMigrationEventInfo> listener, Vm vm, HostSuitability suitability) {
        return new DatacenterVmMigrationEventInfo(vm, suitability, listener);
    }
}

