/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.slametrics;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudsimplus.slametrics.SlaMetric;

public class SlaContract {
    private static final String AVAILABILITY = "Availability";
    private static final String TASK_COMPLETION_TIME = "TaskCompletionTime";
    private static final String CPU_UTILIZATION = "CpuUtilization";
    private static final String WAIT_TIME = "WaitTime";
    private static final String PRICE = "Price";
    private static final String FAULT_TOLERANCE_LEVEL = "FaultToleranceLevel";
    private List<SlaMetric> metrics = new ArrayList<SlaMetric>();

    public static SlaContract getInstance(String jsonFilePath) {
        return SlaContract.getInstanceInternal(ResourceLoader.newInputStream(jsonFilePath, SlaContract.class));
    }

    private static SlaContract getInstanceInternal(InputStream inputStream) {
        return (SlaContract)new Gson().fromJson((Reader)new InputStreamReader(inputStream), SlaContract.class);
    }

    public List<SlaMetric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<SlaMetric> metrics) {
        this.metrics = metrics == null ? new ArrayList() : metrics;
    }

    private SlaMetric getSlaMetric(String metricName) {
        return this.metrics.stream().filter(metric -> metricName.equals(metric.getName())).findFirst().orElse(SlaMetric.NULL);
    }

    public SlaMetric getAvailabilityMetric() {
        return this.getSlaMetric(AVAILABILITY);
    }

    public SlaMetric getCpuUtilizationMetric() {
        return this.getSlaMetric(CPU_UTILIZATION);
    }

    public SlaMetric getPriceMetric() {
        return this.getSlaMetric(PRICE);
    }

    public SlaMetric getWaitTimeMetric() {
        return this.getSlaMetric(WAIT_TIME);
    }

    public SlaMetric getTaskCompletionTimeMetric() {
        return this.getSlaMetric(TASK_COMPLETION_TIME);
    }

    public SlaMetric getFaultToleranceLevel() {
        return this.getSlaMetric(FAULT_TOLERANCE_LEVEL);
    }

    public double getMaxPrice() {
        return this.getPriceMetric().getMaxDimension().getValue();
    }

    public double getExpectedMaxPriceForSingleVm() {
        return this.getMaxPrice() / this.getFaultToleranceLevel().getMinDimension().getValue();
    }

    public int getMinFaultToleranceLevel() {
        return (int)Math.floor(this.getFaultToleranceLevel().getMinDimension().getValue());
    }

    public String toString() {
        return this.metrics.toString();
    }
}

