/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.slametrics;

import java.util.ArrayList;
import java.util.List;
import org.cloudsimplus.slametrics.SlaMetricDimension;

public class SlaMetric {
    public static final SlaMetric NULL = new SlaMetric();
    private static final SlaMetricDimension DEFAULT_MIN_DIMENSION = new SlaMetricDimension(-1.0);
    private static final SlaMetricDimension DEFAULT_MAX_DIMENSION = new SlaMetricDimension(Double.MAX_VALUE);
    private List<SlaMetricDimension> dimensions;
    private String name;

    public SlaMetric() {
        this("");
    }

    public SlaMetric(String name) {
        this.name = name;
        this.dimensions = new ArrayList<SlaMetricDimension>();
    }

    public List<SlaMetricDimension> getDimensions() {
        return this.dimensions;
    }

    public SlaMetric setDimensions(List<SlaMetricDimension> dimensions) {
        this.dimensions = dimensions == null ? new ArrayList() : dimensions;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SlaMetric setName(String name) {
        this.name = name == null ? "" : name;
        return this;
    }

    public String toString() {
        return String.format("Metric{name = %s,  dimensions = %s}", this.name, this.dimensions);
    }

    public SlaMetricDimension getMinDimension() {
        return this.dimensions.stream().filter(SlaMetricDimension::isMinValue).findFirst().orElse(DEFAULT_MIN_DIMENSION);
    }

    public SlaMetricDimension getMaxDimension() {
        return this.dimensions.stream().filter(SlaMetricDimension::isMaxValue).findFirst().orElse(DEFAULT_MAX_DIMENSION);
    }
}

