/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.slametrics;

public final class SlaMetricDimension {
    private static final String MAX_VALUE_NAME = "maxValue";
    private static final String MIN_VALUE_NAME = "minValue";
    private String name = "";
    private String unit = "";
    private double value;

    public SlaMetricDimension() {
        this(0.0);
    }

    public SlaMetricDimension(double value) {
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public SlaMetricDimension setName(String name) {
        this.name = name;
        return this;
    }

    public double getValue() {
        return this.isPercent() ? this.value / 100.0 : this.value;
    }

    public SlaMetricDimension setValue(double value) {
        this.value = value;
        return this;
    }

    public boolean isMaxValue() {
        return this.name.trim().equals(MAX_VALUE_NAME);
    }

    public boolean isMinValue() {
        return this.name.trim().equals(MIN_VALUE_NAME);
    }

    public boolean isPercent() {
        return "Percent".equalsIgnoreCase(this.unit);
    }

    public String toString() {
        return String.format("Dimension{name = %s, value = %s}", this.name, this.value == Double.MAX_VALUE ? "Double.MAX_VALUE" : String.format("%.4f", this.value));
    }

    public String getUnit() {
        return this.unit;
    }

    public SlaMetricDimension setUnit(String unit) {
        this.unit = unit;
        return this;
    }
}

