/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudsimplus.traces.google.GoogleMachineEventsTraceReader;
import org.cloudsimplus.traces.google.TraceField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MachineEventField implements TraceField<GoogleMachineEventsTraceReader>
{
    TIMESTAMP{

        @Override
        public Double getValue(GoogleMachineEventsTraceReader reader) {
            return TimeUtil.microToSeconds(reader.getFieldDoubleValue(this));
        }
    }
    ,
    MACHINE_ID{

        @Override
        public Long getValue(GoogleMachineEventsTraceReader reader) {
            return reader.getFieldLongValue(this);
        }
    }
    ,
    EVENT_TYPE{

        @Override
        public Integer getValue(GoogleMachineEventsTraceReader reader) {
            return reader.getFieldIntValue(this);
        }
    }
    ,
    PLATFORM_ID{

        @Override
        public Integer getValue(GoogleMachineEventsTraceReader reader) {
            return reader.getFieldIntValue(this);
        }
    }
    ,
    CPU_CAPACITY{

        @Override
        public Integer getValue(GoogleMachineEventsTraceReader reader) {
            double fieldValue = reader.getFieldDoubleValue(this);
            return (int)Math.round(fieldValue * (double)reader.getMaxCpuCores());
        }
    }
    ,
    RAM_CAPACITY{

        @Override
        public Long getValue(GoogleMachineEventsTraceReader reader) {
            double fieldValue = reader.getFieldDoubleValue(this);
            return Math.round(fieldValue * (double)reader.getMaxCpuCores());
        }
    };

}

