/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TaskData;
import org.cloudsimplus.traces.google.TaskEventField;
import org.cloudsimplus.traces.google.TaskEventType;

public final class TaskEvent
extends TaskData {
    private int priority;
    private int schedulingClass;
    private TaskEventType type;
    private double resourceRequestForCpuCores;
    private double resourceRequestForRam;
    private double resourceRequestForLocalDiskSpace;
    private String userName;
    private double timestamp;

    public int getPriority() {
        return this.priority;
    }

    TaskEvent setPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public double getResourceRequestForCpuCores() {
        return this.resourceRequestForCpuCores;
    }

    public long actualCpuCores(long maxCpuCores) {
        return (long)(this.resourceRequestForCpuCores * (double)maxCpuCores);
    }

    TaskEvent setResourceRequestForCpuCores(double resourceRequestForCpuCores) {
        this.resourceRequestForCpuCores = resourceRequestForCpuCores;
        return this;
    }

    public double getResourceRequestForRam() {
        return this.resourceRequestForRam;
    }

    TaskEvent setResourceRequestForRam(double resourceRequestForRam) {
        this.resourceRequestForRam = resourceRequestForRam;
        return this;
    }

    public double getResourceRequestForLocalDiskSpace() {
        return this.resourceRequestForLocalDiskSpace;
    }

    TaskEvent setResourceRequestForLocalDiskSpace(double resourceRequestForLocalDiskSpace) {
        this.resourceRequestForLocalDiskSpace = resourceRequestForLocalDiskSpace;
        return this;
    }

    public String getUserName() {
        return this.userName;
    }

    TaskEvent setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public double getTimestamp() {
        return this.timestamp;
    }

    TaskEvent setTimestamp(double timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public int getSchedulingClass() {
        return this.schedulingClass;
    }

    TaskEvent setSchedulingClass(int schedulingClass) {
        this.schedulingClass = schedulingClass;
        return this;
    }

    public TaskEventType getType() {
        return this.type;
    }

    TaskEvent setType(int type) {
        this.type = TaskEventType.getValue(type);
        return this;
    }

    public static TaskEvent of(GoogleTaskEventsTraceReader reader) {
        TaskEvent event = new TaskEvent();
        event.setType((Integer)TaskEventField.EVENT_TYPE.getValue(reader)).setTimestamp((Double)TaskEventField.TIMESTAMP.getValue(reader)).setResourceRequestForCpuCores((Double)TaskEventField.RESOURCE_REQUEST_FOR_CPU_CORES.getValue(reader)).setResourceRequestForLocalDiskSpace((Double)TaskEventField.RESOURCE_REQUEST_FOR_LOCAL_DISK_SPACE.getValue(reader)).setResourceRequestForRam((Double)TaskEventField.RESOURCE_REQUEST_FOR_RAM.getValue(reader)).setPriority((Integer)TaskEventField.PRIORITY.getValue(reader)).setSchedulingClass((Integer)TaskEventField.SCHEDULING_CLASS.getValue(reader)).setUserName((String)TaskEventField.USERNAME.getValue(reader)).setJobId((Long)TaskEventField.JOB_ID.getValue(reader)).setTaskIndex((Long)TaskEventField.TASK_INDEX.getValue(reader));
        return event;
    }
}

