/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TaskEvent;
import org.cloudsimplus.traces.google.TaskEventField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskEventType {
    SUBMIT{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            if (!reader.allowCloudletCreation()) {
                return false;
            }
            TaskEvent event = TaskEvent.of(reader);
            Cloudlet cloudlet = reader.createCloudlet(event);
            cloudlet.setId(event.getUniqueTaskId());
            cloudlet.setJobId(event.getJobId());
            double delay = (Double)TaskEventField.TIMESTAMP.getValue(reader);
            cloudlet.setSubmissionDelay(delay);
            if (delay > 0.0) {
                cloudlet.setStatus(Cloudlet.Status.FROZEN);
            }
            DatacenterBroker broker = reader.getBrokerManager().getOrCreateBroker(event.getUserName());
            if (reader.isAutoSubmitCloudlets()) {
                broker.submitCloudlet(cloudlet);
            }
            return reader.addAvailableObject(cloudlet);
        }
    }
    ,
    SCHEDULE{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(CloudSimTag.CLOUDLET_READY);
        }
    }
    ,
    EVICT{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(CloudSimTag.CLOUDLET_PAUSE);
        }
    }
    ,
    FAIL{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(CloudSimTag.CLOUDLET_FAIL);
        }
    }
    ,
    FINISH{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(CloudSimTag.CLOUDLET_FINISH);
        }
    }
    ,
    KILL{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return reader.requestCloudletStatusChange(CloudSimTag.CLOUDLET_CANCEL);
        }
    }
    ,
    LOST{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    }
    ,
    UPDATE_PENDING{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    }
    ,
    UPDATE_RUNNING{

        @Override
        protected boolean process(GoogleTaskEventsTraceReader reader) {
            return false;
        }
    };


    public static TaskEventType getValue(int ordinal) {
        return TaskEventType.values()[ordinal];
    }

    protected abstract boolean process(GoogleTaskEventsTraceReader var1);

    protected static TaskEventType of(GoogleTaskEventsTraceReader reader) {
        return TaskEventType.getValue((Integer)TaskEventField.EVENT_TYPE.getValue(reader));
    }
}

