/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import java.util.Objects;
import org.cloudsimplus.traces.google.GoogleTaskUsageTraceReader;
import org.cloudsimplus.traces.google.TaskData;

public final class TaskUsage
extends TaskData {
    private double startTime;
    private double endTime;
    private double meanCpuUsageRate;
    private double canonicalMemoryUsage;
    private double assignedMemoryUsage;
    private double maximumMemoryUsage;
    private double meanDiskIoTime;
    private double meanLocalDiskSpaceUsed;
    private double maximumCpuUsage;
    private double maximumDiskIoTime;

    public TaskUsage(GoogleTaskUsageTraceReader reader) {
        Objects.requireNonNull(reader);
        this.startTime = (Double)GoogleTaskUsageTraceReader.FieldIndex.START_TIME.getValue(reader);
        this.endTime = (Double)GoogleTaskUsageTraceReader.FieldIndex.END_TIME.getValue(reader);
        this.meanCpuUsageRate = (Double)GoogleTaskUsageTraceReader.FieldIndex.MEAN_CPU_USAGE_RATE.getValue(reader);
        this.canonicalMemoryUsage = (Double)GoogleTaskUsageTraceReader.FieldIndex.CANONICAL_MEMORY_USAGE.getValue(reader);
        this.assignedMemoryUsage = (Double)GoogleTaskUsageTraceReader.FieldIndex.ASSIGNED_MEMORY_USAGE.getValue(reader);
        this.maximumMemoryUsage = (Double)GoogleTaskUsageTraceReader.FieldIndex.MAXIMUM_MEMORY_USAGE.getValue(reader);
        this.meanDiskIoTime = (Double)GoogleTaskUsageTraceReader.FieldIndex.MEAN_DISK_IO_TIME.getValue(reader);
        this.meanLocalDiskSpaceUsed = (Double)GoogleTaskUsageTraceReader.FieldIndex.MEAN_LOCAL_DISK_SPACE_USED.getValue(reader);
        this.maximumCpuUsage = (Double)GoogleTaskUsageTraceReader.FieldIndex.MAXIMUM_CPU_USAGE.getValue(reader);
        this.maximumDiskIoTime = (Double)GoogleTaskUsageTraceReader.FieldIndex.MAXIMUM_DISK_IO_TIME.getValue(reader);
        this.setJobId((Long)GoogleTaskUsageTraceReader.FieldIndex.JOB_ID.getValue(reader));
        this.setTaskIndex((Long)GoogleTaskUsageTraceReader.FieldIndex.TASK_INDEX.getValue(reader));
        this.setMachineId((Long)GoogleTaskUsageTraceReader.FieldIndex.MACHINE_ID.getValue(reader));
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getMeanCpuUsageRate() {
        return this.meanCpuUsageRate;
    }

    public double getCanonicalMemoryUsage() {
        return this.canonicalMemoryUsage;
    }

    public double getAssignedMemoryUsage() {
        return this.assignedMemoryUsage;
    }

    public double getMaximumMemoryUsage() {
        return this.maximumMemoryUsage;
    }

    public double getMeanDiskIoTime() {
        return this.meanDiskIoTime;
    }

    public double getMeanLocalDiskSpaceUsed() {
        return this.meanLocalDiskSpaceUsed;
    }

    public double getMaximumCpuUsage() {
        return this.maximumCpuUsage;
    }

    public double getMaximumDiskIoTime() {
        return this.maximumDiskIoTime;
    }
}

