/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.vmtemplates;

import com.google.gson.Gson;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cloudbus.cloudsim.util.ResourceLoader;

public class AwsEc2Template
implements Comparable<AwsEc2Template> {
    public static final AwsEc2Template NULL = new AwsEc2Template();
    private Path path;
    private String name;
    private int cpus;
    private int memoryInMB;
    private double pricePerHour;
    private String region;

    public AwsEc2Template() {
    }

    public AwsEc2Template(AwsEc2Template source) {
        this.name = source.name;
        this.cpus = source.cpus;
        this.region = source.region;
        this.memoryInMB = source.memoryInMB;
        this.pricePerHour = source.pricePerHour;
        this.path = Paths.get(source.path.toUri());
    }

    public AwsEc2Template(String jsonFilePath) {
        this(AwsEc2Template.getInstanceInternal(jsonFilePath, ResourceLoader.newInputStreamReader(jsonFilePath)));
    }

    public static AwsEc2Template getInstance(String jsonFilePath) {
        InputStreamReader reader = ResourceLoader.newInputStreamReader(jsonFilePath, AwsEc2Template.class);
        return AwsEc2Template.getInstanceInternal(jsonFilePath, reader);
    }

    private static AwsEc2Template getInstanceInternal(String jsonFilePath, InputStreamReader reader) {
        AwsEc2Template template = (AwsEc2Template)new Gson().fromJson((Reader)reader, AwsEc2Template.class);
        template.path = Paths.get(jsonFilePath, new String[0]);
        return template;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getCpus() {
        return this.cpus;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public int getMemoryInMB() {
        return this.memoryInMB;
    }

    public void setMemoryInMB(int memoryInMB) {
        this.memoryInMB = memoryInMB;
    }

    public double getPricePerHour() {
        return this.pricePerHour;
    }

    public void setPricePerHour(double pricePerHour) {
        if (pricePerHour < 0.0) {
            throw new IllegalArgumentException("Price cannot be negative");
        }
        this.pricePerHour = pricePerHour;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getFilePath() {
        return this.path.toAbsolutePath().toString();
    }

    public String getFileName() {
        return this.path.getFileName().toString();
    }

    public String toString() {
        return "AwsEc2Template {name = " + this.name + ",  cpus = " + this.cpus + ",  memoryInMB = " + this.memoryInMB + ",  pricePerHour = " + this.pricePerHour + "}";
    }

    @Override
    public int compareTo(AwsEc2Template template) {
        int comparison = Double.compare(this.cpus, template.cpus);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Double.compare(this.memoryInMB, template.memoryInMB);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Double.compare(this.pricePerHour, template.pricePerHour);
        return comparison;
    }
}

