/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.allocationpolicies.migration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicy;
import org.cloudbus.cloudsim.allocationpolicies.VmAllocationPolicyAbstract;
import org.cloudbus.cloudsim.allocationpolicies.migration.VmAllocationPolicyMigration;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;

public abstract class VmAllocationPolicyMigrationAbstract
extends VmAllocationPolicyAbstract
implements VmAllocationPolicyMigration {
    public static final double DEF_UNDERLOAD_THRESHOLD = 0.35;
    private double underUtilizationThreshold = 0.35;
    private VmSelectionPolicy vmSelectionPolicy;
    private final Map<Vm, Host> savedAllocation = new HashMap<Vm, Host>();
    private boolean hostsUnderloaded;
    private boolean hostsOverloaded;
    private Datacenter targetMigrationDc;
    private int targetMigrationDcIndex;

    public VmAllocationPolicyMigrationAbstract(VmSelectionPolicy vmSelectionPolicy) {
        this(vmSelectionPolicy, null);
    }

    @Override
    public void setDatacenter(Datacenter datacenter) {
        super.setDatacenter(datacenter);
        this.targetMigrationDc = datacenter;
    }

    public VmAllocationPolicyMigrationAbstract(VmSelectionPolicy vmSelectionPolicy, BiFunction<VmAllocationPolicy, Vm, Optional<Host>> findHostForVmFunction) {
        super(findHostForVmFunction);
        this.setVmSelectionPolicy(vmSelectionPolicy);
    }

    @Override
    public Map<Vm, Host> getOptimizedAllocationMap(List<? extends Vm> vmList) {
        Set<Host> overloadedHosts = this.getOverloadedHosts();
        this.hostsOverloaded = !overloadedHosts.isEmpty();
        this.printOverUtilizedHosts(overloadedHosts);
        Map<Vm, Host> migrationMap = this.getMigrationMapFromOverloadedHosts(overloadedHosts);
        this.updateMigrationMapFromUnderloadedHosts(overloadedHosts, migrationMap);
        if (this.hostsOverloaded && migrationMap.isEmpty()) {
            this.hostSearchRetry();
        }
        return migrationMap;
    }

    private void hostSearchRetry() {
        List<Datacenter> dcList = this.getDatacenter().getSimulation().getCloudInfoService().getDatacenterList();
        double hostSearchRetryDelay = this.getDatacenter().getHostSearchRetryDelay();
        String msg = hostSearchRetryDelay > 0.0 ? "in " + TimeUtil.secondsToStr(hostSearchRetryDelay) : "as soon as possible";
        boolean singleDc = dcList.size() == 1;
        String targetDcName = singleDc || this.getDatacenter().equals(this.targetMigrationDc) ? "" : String.format("on %s ", this.targetMigrationDc);
        LOGGER.warn("{}: {}: An under or overload situation was detected on {}, however there aren't suitable Hosts {}to manage that. Trying again {}.", new Object[]{this.getDatacenter().getSimulation().clock(), this.getClass().getSimpleName(), this.getDatacenter(), targetDcName, msg});
        if (!singleDc) {
            ++this.targetMigrationDcIndex;
            this.targetMigrationDcIndex %= dcList.size();
            this.targetMigrationDc = dcList.get(this.targetMigrationDcIndex);
        }
    }

    private void updateMigrationMapFromUnderloadedHosts(Set<Host> overloadedHosts, Map<Vm, Host> migrationMap) {
        Host underloadedHost;
        List<Host> switchedOffHosts = this.getSwitchedOffHosts();
        Set<Host> ignoredSourceHosts = this.getIgnoredHosts(overloadedHosts, switchedOffHosts);
        ignoredSourceHosts.addAll(migrationMap.values());
        Set<Host> ignoredTargetHosts = this.getIgnoredHosts(overloadedHosts, switchedOffHosts);
        int numberOfHosts = this.getHostList().size();
        this.hostsUnderloaded = false;
        while (numberOfHosts != ignoredSourceHosts.size() && !Host.NULL.equals(underloadedHost = this.getUnderloadedHost(ignoredSourceHosts))) {
            this.hostsUnderloaded = true;
            LOGGER.info("{}: VmAllocationPolicy: Underloaded hosts: {}", (Object)this.getDatacenter().getSimulation().clockStr(), (Object)underloadedHost);
            ignoredSourceHosts.add(underloadedHost);
            ignoredTargetHosts.add(underloadedHost);
            List<? extends Vm> vmsToMigrateList = this.getVmsToMigrateFromUnderUtilizedHost(underloadedHost);
            if (vmsToMigrateList.isEmpty()) continue;
            this.logVmsToBeReallocated(underloadedHost, vmsToMigrateList);
            Map<Vm, Host> newVmPlacement = this.getNewVmPlacementFromUnderloadedHost(vmsToMigrateList, ignoredTargetHosts);
            ignoredSourceHosts.addAll(this.extractHostListFromMigrationMap(newVmPlacement));
            migrationMap.putAll(newVmPlacement);
        }
    }

    private void logVmsToBeReallocated(Host underloadedHost, List<? extends Vm> migratingOutVms) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("{}: VmAllocationPolicy: VMs to be reallocated from the underloaded {}: {}", new Object[]{this.getDatacenter().getSimulation().clockStr(), underloadedHost, this.getVmIds(migratingOutVms)});
        }
    }

    private Set<Host> getIgnoredHosts(Set<Host> overloadedHosts, List<Host> switchedOffHosts) {
        HashSet<Host> ignoredHostsSet = new HashSet<Host>();
        ignoredHostsSet.addAll(overloadedHosts);
        ignoredHostsSet.addAll(switchedOffHosts);
        return ignoredHostsSet;
    }

    private String getVmIds(List<? extends Vm> vmList) {
        return vmList.stream().map(vm -> String.valueOf(vm.getId())).collect(Collectors.joining(", "));
    }

    private void printOverUtilizedHosts(Set<Host> overloadedHosts) {
        if (!overloadedHosts.isEmpty() && LOGGER.isWarnEnabled()) {
            String hosts = overloadedHosts.stream().map(this::overloadedHostToString).collect(Collectors.joining(System.lineSeparator()));
            LOGGER.warn("{}: VmAllocationPolicy: Overloaded hosts in {}:{}{}", new Object[]{this.getDatacenter().getSimulation().clockStr(), this.getDatacenter(), System.lineSeparator(), hosts});
        }
    }

    private String overloadedHostToString(Host host) {
        return String.format("      Host %d (upper CPU threshold %.2f, current utilization: %.2f)", host.getId(), this.getOverUtilizationThreshold(host), host.getCpuPercentUtilization());
    }

    protected double getPowerDifferenceAfterAllocation(Host host, Vm vm) {
        double powerAfterAllocation = this.getPowerAfterAllocation(host, vm);
        if (powerAfterAllocation > 0.0) {
            return powerAfterAllocation - host.getPowerModel().getPower();
        }
        return 0.0;
    }

    private boolean isNotHostOverloadedAfterAllocation(Host host, Vm vm) {
        VmSimple tempVm = new VmSimple(vm);
        if (!host.createTemporaryVm(tempVm).fully()) {
            return false;
        }
        double usagePercent = this.getHostCpuPercentRequested(host);
        boolean notOverloadedAfterAllocation = !this.isHostOverloaded(host, usagePercent);
        host.destroyTemporaryVm(tempVm);
        return notOverloadedAfterAllocation;
    }

    @Override
    public boolean isHostOverloaded(Host host) {
        return this.isHostOverloaded(host, host.getCpuPercentUtilization());
    }

    private boolean isHostOverloaded(Host host, double cpuUsagePercent) {
        return cpuUsagePercent > this.getOverUtilizationThreshold(host);
    }

    @Override
    public boolean isHostUnderloaded(Host host) {
        return this.getHostCpuPercentRequested(host) < this.getUnderUtilizationThreshold();
    }

    @Override
    protected Optional<Host> defaultFindHostForVm(Vm vm) {
        return this.findHostForVm(vm, host -> true);
    }

    private Optional<Host> findHostForVm(Vm vm, Predicate<Host> predicate) {
        Predicate<Host> newPredicate = predicate.and(host -> !host.equals(vm.getHost())).and(host -> host.isSuitableForVm(vm)).and(host -> this.isNotHostOverloadedAfterAllocation((Host)host, vm));
        return this.findHostForVmInternal(vm, newPredicate);
    }

    protected Optional<Host> findHostForVmInternal(Vm vm, Predicate<Host> predicate) {
        Comparator<Host> hostPowerConsumptionComparator = Comparator.comparingDouble(host -> this.getPowerDifferenceAfterAllocation((Host)host, vm));
        return this.getHostList().stream().filter(predicate).min(hostPowerConsumptionComparator);
    }

    private List<Host> extractHostListFromMigrationMap(Map<Vm, Host> migrationMap) {
        return new ArrayList<Host>(migrationMap.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Vm, Host> getMigrationMapFromOverloadedHosts(Set<Host> overloadedHosts) {
        if (overloadedHosts.isEmpty()) {
            return Collections.emptyMap();
        }
        this.saveAllocation();
        HashMap<Vm, Host> migrationMap = new HashMap<Vm, Host>();
        try {
            List<Vm> vmsToMigrateList = this.getVmsToMigrateFromOverloadedHosts(overloadedHosts);
            this.sortByCpuUtilization(vmsToMigrateList, this.getDatacenter().getSimulation().clock());
            StringBuilder builder = new StringBuilder();
            VmAllocationPolicy targetVmAllocationPolicy = this.targetMigrationDc.getVmAllocationPolicy();
            for (Vm vm : vmsToMigrateList) {
                targetVmAllocationPolicy.findHostForVm(vm).ifPresent(targetHost -> {
                    this.addVmToMigrationMap(migrationMap, vm, targetHost);
                    this.appendVmMigrationMsgToStringBuilder(builder, vm, (Host)targetHost);
                });
            }
            if (!migrationMap.isEmpty()) {
                LOGGER.info("{}: {}: Reallocation of VMs from overloaded hosts: {}{}", new Object[]{this.getDatacenter().getSimulation().clockStr(), this.getClass().getSimpleName(), System.lineSeparator(), builder});
            }
        }
        finally {
            this.restoreAllocation();
        }
        return migrationMap;
    }

    private void appendVmMigrationMsgToStringBuilder(StringBuilder builder, Vm vm, Host targetHost) {
        if (LOGGER.isInfoEnabled()) {
            builder.append("      ").append(vm).append(" will be migrated from ").append(vm.getHost()).append(" to ").append(targetHost).append(System.lineSeparator());
        }
    }

    private Map<Vm, Host> getNewVmPlacementFromUnderloadedHost(List<? extends Vm> vmsToMigrate, Set<? extends Host> excludedHosts) {
        HashMap<Vm, Host> migrationMap = new HashMap<Vm, Host>();
        this.sortByCpuUtilization(vmsToMigrate, this.getDatacenter().getSimulation().clock());
        for (Vm vm : vmsToMigrate) {
            Optional<Host> optional = this.findHostForVm(vm, host -> !this.isHostUnderloaded((Host)host));
            if (optional.isEmpty()) {
                LOGGER.warn("{}: VmAllocationPolicy: A new Host, which isn't also underloaded or won't be overloaded, couldn't be found to migrate {}. Migration of VMs from the underloaded {} cancelled.", new Object[]{this.getDatacenter().getSimulation().clockStr(), vm, vm.getHost()});
                return new HashMap<Vm, Host>();
            }
            this.addVmToMigrationMap(migrationMap, vm, optional.get());
        }
        return migrationMap;
    }

    private void sortByCpuUtilization(List<? extends Vm> vmList, double simulationTime) {
        Comparator<Vm> comparator = Comparator.comparingDouble(vm -> vm.getTotalCpuMipsUtilization(simulationTime));
        vmList.sort(comparator.reversed());
    }

    private <T extends Host> void addVmToMigrationMap(Map<Vm, T> migrationMap, Vm vm, T targetHost) {
        targetHost.createTemporaryVm(vm);
        migrationMap.put(vm, targetHost);
    }

    private List<Vm> getVmsToMigrateFromOverloadedHosts(Set<Host> overloadedHosts) {
        LinkedList<Vm> vmsToMigrateList = new LinkedList<Vm>();
        for (Host host : overloadedHosts) {
            vmsToMigrateList.addAll(this.getVmsToMigrateFromOverloadedHost(host));
        }
        return vmsToMigrateList;
    }

    private List<Vm> getVmsToMigrateFromOverloadedHost(Host host) {
        Optional<Vm> optionalVm;
        LinkedList<Vm> vmsToMigrateList = new LinkedList<Vm>();
        while (!(optionalVm = this.getVmSelectionPolicy().getVmToMigrate(host)).isEmpty()) {
            Vm vm = optionalVm.get();
            vmsToMigrateList.add(vm);
            host.destroyTemporaryVm(vm);
            if (this.isHostOverloaded(host)) continue;
            break;
        }
        return vmsToMigrateList;
    }

    protected List<? extends Vm> getVmsToMigrateFromUnderUtilizedHost(Host host) {
        return host.getMigratableVms();
    }

    protected List<Host> getSwitchedOffHosts() {
        return this.getHostList().stream().filter(this::isShutdownOrFailed).collect(Collectors.toList());
    }

    private boolean isShutdownOrFailed(Host host) {
        return !host.isActive() || host.isFailed();
    }

    private Set<Host> getOverloadedHosts() {
        return this.getHostList().stream().filter(this::isHostOverloaded).filter(host -> host.getVmsMigratingOut().isEmpty()).collect(Collectors.toSet());
    }

    private Host getUnderloadedHost(Set<? extends Host> excludedHosts) {
        return this.getHostList().stream().filter(host -> !excludedHosts.contains(host)).filter(Host::isActive).filter(this::isHostUnderloaded).filter(host -> host.getVmsMigratingIn().isEmpty()).filter(this::notAllVmsAreMigratingOut).min(Comparator.comparingDouble(Host::getCpuPercentUtilization)).orElse(Host.NULL);
    }

    private double getHostCpuPercentRequested(Host host) {
        return this.getHostTotalRequestedMips(host) / host.getTotalMipsCapacity();
    }

    private double getHostTotalRequestedMips(Host host) {
        return host.getVmList().stream().mapToDouble(Vm::getTotalCpuMipsRequested).sum();
    }

    private boolean notAllVmsAreMigratingOut(Host host) {
        return host.getVmList().stream().anyMatch(vm -> !vm.isInMigration());
    }

    private void saveAllocation() {
        this.savedAllocation.clear();
        for (Host host : this.getHostList()) {
            for (Vm vm : host.getVmList()) {
                if (host.getVmsMigratingIn().contains(vm)) continue;
                this.savedAllocation.put(vm, host);
            }
        }
    }

    private void restoreAllocation() {
        for (Host host : this.getHostList()) {
            host.destroyAllVms();
            host.reallocateMigratingInVms();
        }
        for (Vm vm : this.savedAllocation.keySet()) {
            Host host = this.savedAllocation.get(vm);
            if (host.createTemporaryVm(vm).fully()) {
                vm.setCreated(true);
                continue;
            }
            LOGGER.error("VmAllocationPolicy: Couldn't restore {} on {}", (Object)vm, (Object)host);
        }
    }

    protected double getPowerAfterAllocation(Host host, Vm vm) {
        try {
            return host.getPowerModel().getPower(this.getMaxUtilizationAfterAllocation(host, vm));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("Power consumption for {} could not be determined: {}", (Object)host, (Object)e.getMessage());
            return 0.0;
        }
    }

    protected double getMaxUtilizationAfterAllocation(Host host, Vm vm) {
        double requestedTotalMips = vm.getTotalCpuMipsRequested();
        double hostUtilizationMips = this.getUtilizationOfCpuMips(host);
        double hostPotentialMipsUse = hostUtilizationMips + requestedTotalMips;
        return hostPotentialMipsUse / host.getTotalMipsCapacity();
    }

    protected double getUtilizationOfCpuMips(Host host) {
        double hostUtilizationMips = 0.0;
        for (Vm vm : host.getVmList()) {
            double additionalMips = this.additionalCpuUtilizationDuringMigration(host, vm);
            hostUtilizationMips += additionalMips + host.getTotalAllocatedMipsForVm(vm);
        }
        return hostUtilizationMips;
    }

    private double additionalCpuUtilizationDuringMigration(Host host, Vm vm) {
        if (!host.getVmsMigratingIn().contains(vm)) {
            return 0.0;
        }
        double maxCpuUtilization = host.getVmScheduler().getMaxCpuUsagePercentDuringOutMigration();
        double migrationOverhead = host.getVmScheduler().getVmMigrationCpuOverhead();
        return host.getTotalAllocatedMipsForVm(vm) * maxCpuUtilization / migrationOverhead;
    }

    @Override
    public final void setVmSelectionPolicy(VmSelectionPolicy vmSelectionPolicy) {
        this.vmSelectionPolicy = Objects.requireNonNull(vmSelectionPolicy);
    }

    @Override
    public VmSelectionPolicy getVmSelectionPolicy() {
        return this.vmSelectionPolicy;
    }

    @Override
    public double getUnderUtilizationThreshold() {
        return this.underUtilizationThreshold;
    }

    @Override
    public void setUnderUtilizationThreshold(double underUtilizationThreshold) {
        if (underUtilizationThreshold <= 0.0 || underUtilizationThreshold >= 1.0) {
            throw new IllegalArgumentException("Under utilization threshold must be greater than 0 and lower than 1.");
        }
        this.underUtilizationThreshold = underUtilizationThreshold;
    }

    @Override
    public final boolean isVmMigrationSupported() {
        return true;
    }

    @Override
    public boolean areHostsUnderloaded() {
        return this.hostsUnderloaded;
    }

    @Override
    public boolean areHostsOverloaded() {
        return this.hostsOverloaded;
    }
}

