/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.brokers;

import org.cloudbus.cloudsim.brokers.DatacenterBrokerSimple;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.vms.Vm;

public class DatacenterBrokerFirstFit
extends DatacenterBrokerSimple {
    private int lastVmIndex;

    public DatacenterBrokerFirstFit(CloudSim simulation) {
        super(simulation);
    }

    @Override
    public Vm defaultVmMapper(Cloudlet cloudlet) {
        if (cloudlet.isBoundToVm()) {
            return cloudlet.getVm();
        }
        int maxTries = this.getVmCreatedList().size();
        for (int i = 0; i < maxTries; ++i) {
            Vm vm = (Vm)this.getVmCreatedList().get(this.lastVmIndex);
            if (vm.getExpectedFreePesNumber() >= cloudlet.getNumberOfPes()) {
                LOGGER.trace("{}: {}: {} (PEs: {}) mapped to {} (available PEs: {}, tot PEs: {})", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getNumberOfPes(), vm, vm.getExpectedFreePesNumber(), vm.getFreePesNumber()});
                return vm;
            }
            ++this.lastVmIndex;
            this.lastVmIndex %= this.getVmCreatedList().size();
        }
        LOGGER.warn("{}: {}: {} (PEs: {}) couldn't be mapped to any suitable VM.", new Object[]{this.getSimulation().clockStr(), this.getName(), cloudlet, cloudlet.getNumberOfPes()});
        return Vm.NULL;
    }
}

