/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.core.events;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.core.events.EventQueue;
import org.cloudbus.cloudsim.core.events.SimEvent;

public class DeferredQueue
implements EventQueue {
    private final List<SimEvent> eventList = new LinkedList<SimEvent>();
    private double maxTime = -1.0;
    private int addedToTail;
    private int addedToMiddle;
    private int maxSize;

    @Override
    public void addEvent(SimEvent newEvent) {
        double eventTime = newEvent.getTime();
        this.maxSize = Math.max(this.maxSize, this.eventList.size());
        if (eventTime >= this.maxTime) {
            this.eventList.add(newEvent);
            this.maxTime = eventTime;
            ++this.addedToTail;
            return;
        }
        ListIterator<SimEvent> reverseEvtIterator = this.eventList.listIterator(this.eventList.size() - 1);
        while (reverseEvtIterator.hasPrevious()) {
            if (!(reverseEvtIterator.previous().getTime() <= eventTime)) continue;
            reverseEvtIterator.next();
            reverseEvtIterator.add(newEvent);
            ++this.addedToMiddle;
            return;
        }
        this.eventList.add(newEvent);
    }

    @Override
    public Iterator<SimEvent> iterator() {
        return this.eventList.iterator();
    }

    @Override
    public Stream<SimEvent> stream() {
        return this.eventList.stream();
    }

    @Override
    public int size() {
        return this.eventList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.eventList.isEmpty();
    }

    public boolean remove(SimEvent event) {
        return this.eventList.remove(event);
    }

    public boolean removeAll(Collection<SimEvent> events) {
        return this.eventList.removeAll(events);
    }

    public boolean removeIf(Predicate<SimEvent> predicate) {
        return this.eventList.removeIf(predicate);
    }

    public void clear() {
        this.eventList.clear();
    }

    @Override
    public SimEvent first() throws NoSuchElementException {
        if (this.eventList.isEmpty()) {
            throw new NoSuchElementException("The Deferred Queue is empty.");
        }
        return this.eventList.get(0);
    }

    public int getAddedToTail() {
        return this.addedToTail;
    }

    public int getAddedToMiddle() {
        return this.addedToMiddle;
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

