/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.datacenters;

import org.cloudbus.cloudsim.core.AbstractMachine;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.datacenters.DatacenterCharacteristics;
import org.cloudbus.cloudsim.hosts.Host;

public class DatacenterCharacteristicsSimple
implements DatacenterCharacteristics {
    private String architecture;
    private String os;
    private double costPerSecond;
    private String vmm;
    private double costPerMem;
    private double costPerStorage;
    private double costPerBw;
    private final Datacenter datacenter;

    public DatacenterCharacteristicsSimple(Datacenter datacenter) {
        this.setArchitecture("x86");
        this.setOs("Linux");
        this.setVmm("Xen");
        this.setCostPerSecond(0.0);
        this.setCostPerMem(0.0);
        this.setCostPerStorage(0.0);
        this.setCostPerBw(0.0);
        this.datacenter = datacenter;
    }

    @Override
    public double getMips() {
        return this.datacenter.getHostList().stream().mapToDouble(Host::getTotalMipsCapacity).sum();
    }

    @Override
    public int getNumberOfPes() {
        return (int)this.datacenter.getHostList().stream().mapToLong(AbstractMachine::getNumberOfPes).sum();
    }

    @Override
    public long getNumberOfFailedHosts() {
        return this.datacenter.getHostList().stream().filter(Host::isFailed).count();
    }

    @Override
    public boolean isWorking() {
        return this.getNumberOfFailedHosts() == 0L;
    }

    @Override
    public double getCostPerMem() {
        return this.costPerMem;
    }

    @Override
    public final DatacenterCharacteristics setCostPerMem(double costPerMem) {
        this.costPerMem = costPerMem;
        return this;
    }

    @Override
    public double getCostPerStorage() {
        return this.costPerStorage;
    }

    @Override
    public final DatacenterCharacteristics setCostPerStorage(double costPerStorage) {
        this.costPerStorage = costPerStorage;
        return this;
    }

    @Override
    public double getCostPerBw() {
        return this.costPerBw;
    }

    @Override
    public final DatacenterCharacteristics setCostPerBw(double costPerBw) {
        this.costPerBw = costPerBw;
        return this;
    }

    @Override
    public String getVmm() {
        return this.vmm;
    }

    @Override
    public long getId() {
        return this.datacenter.getId();
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public final DatacenterCharacteristics setArchitecture(String architecture) {
        this.architecture = architecture;
        return this;
    }

    @Override
    public String getOs() {
        return this.os;
    }

    @Override
    public final DatacenterCharacteristics setOs(String os) {
        this.os = os;
        return this;
    }

    @Override
    public double getCostPerSecond() {
        return this.costPerSecond;
    }

    @Override
    public final DatacenterCharacteristics setCostPerSecond(double costPerSecond) {
        this.costPerSecond = costPerSecond;
        return this;
    }

    @Override
    public final DatacenterCharacteristics setVmm(String vmm) {
        this.vmm = vmm;
        return this;
    }

    @Override
    public Datacenter getDatacenter() {
        return this.datacenter;
    }
}

