/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network;

import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class FloydWarshall {
    private final int numVertices;
    private final List<Integer> vertices;
    private final double[][] dk_minus_one;
    private final int[][] pk;
    private final int[][] pk_minus_one;

    public FloydWarshall(int numVertices) {
        if (numVertices < 0) {
            throw new IllegalArgumentException("Number of vertices cannot be negative.");
        }
        this.numVertices = numVertices;
        this.vertices = IntStream.range(0, numVertices).boxed().collect(Collectors.toList());
        this.dk_minus_one = new double[numVertices][numVertices];
        this.pk = new int[numVertices][numVertices];
        this.pk_minus_one = new int[numVertices][numVertices];
    }

    public double[][] computeShortestPaths(double[][] originalDelayMatrix) {
        this.savePreviousDelays(originalDelayMatrix);
        return this.computeShortestPaths();
    }

    private double[][] computeShortestPaths() {
        double[][] dk = new double[this.numVertices][this.numVertices];
        for (int k : this.vertices) {
            this.computeShortestPathForSpecificNumberOfHops(dk, k);
        }
        return dk;
    }

    private void computeShortestPathForSpecificNumberOfHops(double[][] dk, int k) {
        for (int i2 : this.vertices) {
            this.computeShortestPathFromVertexToAllVertices(dk, k, i2);
        }
        this.updateMatrices((i, j) -> {
            this.dk_minus_one[i.intValue()][j.intValue()] = dk[i][j];
            this.pk_minus_one[i.intValue()][j.intValue()] = this.pk[i][j];
        });
    }

    private void updateMatrices(BiConsumer<Integer, Integer> updater) {
        for (int i : this.vertices) {
            for (int j : this.vertices) {
                updater.accept(i, j);
            }
        }
    }

    private void computeShortestPathFromVertexToAllVertices(double[][] dk, int k, int i) {
        for (int j : this.vertices) {
            this.pk[i][j] = -1;
            if (i == j) continue;
            if (this.dk_minus_one[i][j] <= this.dk_minus_one[i][k] + this.dk_minus_one[k][j]) {
                dk[i][j] = this.dk_minus_one[i][j];
                this.pk[i][j] = this.pk_minus_one[i][j];
                continue;
            }
            dk[i][j] = this.dk_minus_one[i][k] + this.dk_minus_one[k][j];
            this.pk[i][j] = this.pk_minus_one[k][j];
        }
    }

    private void savePreviousDelays(double[][] originalDelayMatrix) {
        for (int i : this.vertices) {
            for (int j : this.vertices) {
                this.dk_minus_one[i][j] = Double.MAX_VALUE;
                this.pk_minus_one[i][j] = -1;
                if (originalDelayMatrix[i][j] == 0.0) continue;
                this.dk_minus_one[i][j] = originalDelayMatrix[i][j];
                this.pk_minus_one[i][j] = i;
            }
        }
    }

    public int[][] getPk() {
        return (int[][])Arrays.copyOf(this.pk, this.pk.length);
    }

    public int getNumVertices() {
        return this.numVertices;
    }
}

