/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.switches;

import java.util.List;
import java.util.Optional;
import org.cloudbus.cloudsim.core.CloudSim;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.network.NetworkDatacenter;
import org.cloudbus.cloudsim.network.HostPacket;
import org.cloudbus.cloudsim.network.switches.AbstractSwitch;
import org.cloudbus.cloudsim.network.switches.EdgeSwitch;
import org.cloudbus.cloudsim.network.switches.Switch;
import org.cloudbus.cloudsim.util.BytesConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootSwitch
extends AbstractSwitch {
    public static final int LEVEL = 0;
    public static final int PORTS = 1;
    public static final double SWITCHING_DELAY = 0.00285;
    public static final long DOWNLINK_BW = (long)BytesConversion.gigaToMega(320.0);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RootSwitch.class.getSimpleName());

    public RootSwitch(CloudSim simulation, NetworkDatacenter dc) {
        super(simulation, dc);
        this.setDownlinkBandwidth(DOWNLINK_BW);
        this.setSwitchingDelay(0.00285);
        this.setPorts(1);
    }

    @Override
    protected void processPacketUp(SimEvent evt) {
        super.processPacketUp(evt);
        HostPacket netPkt = (HostPacket)evt.getData();
        EdgeSwitch edgeSwitch = netPkt.getVmEdgeSwitch();
        Optional<Switch> optionalAggrSw = this.findAggregateConnectedToEdgeSwitch(edgeSwitch);
        optionalAggrSw.ifPresentOrElse(aggSw -> this.addPacketToSendToDownlinkSwitch((Switch)aggSw, netPkt), () -> LOGGER.error("No destination switch for this packet"));
    }

    private Optional<Switch> findAggregateConnectedToEdgeSwitch(Switch edgeSwitch) {
        List<Switch> aggregateSwitchList = this.getDownlinkSwitches();
        return aggregateSwitchList.stream().filter(aggregateSw -> this.isEdgeConnectedToAggregatedSwitch(edgeSwitch, (Switch)aggregateSw)).findFirst();
    }

    private boolean isEdgeConnectedToAggregatedSwitch(Switch edgeSwitch, Switch aggregateSw) {
        List<Switch> edgeSwitchList = aggregateSw.getDownlinkSwitches();
        return edgeSwitchList.stream().anyMatch(edgeSwitch::equals);
    }

    @Override
    public int getLevel() {
        return 0;
    }
}

