/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.network.topologies;

import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.cloudbus.cloudsim.core.SimEntity;
import org.cloudbus.cloudsim.network.DelayMatrix;
import org.cloudbus.cloudsim.network.topologies.NetworkTopology;
import org.cloudbus.cloudsim.network.topologies.TopologicalGraph;
import org.cloudbus.cloudsim.network.topologies.TopologicalLink;
import org.cloudbus.cloudsim.network.topologies.TopologicalNode;
import org.cloudbus.cloudsim.network.topologies.readers.TopologyReaderBrite;
import org.cloudbus.cloudsim.util.ResourceLoader;
import org.cloudbus.cloudsim.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BriteNetworkTopology
implements NetworkTopology {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BriteNetworkTopology.class.getSimpleName());
    private int nextIdx;
    private boolean networkEnabled;
    private DelayMatrix delayMatrix;
    private double[][] bwMatrix;
    private TopologicalGraph graph;
    private Map<SimEntity, Integer> entitiesMap = new HashMap<SimEntity, Integer>();

    public static BriteNetworkTopology getInstance(String fileName) {
        InputStreamReader reader = ResourceLoader.newInputStreamReader(fileName, BriteNetworkTopology.class);
        return new BriteNetworkTopology(reader);
    }

    public BriteNetworkTopology() {
        this.bwMatrix = new double[0][0];
        this.graph = new TopologicalGraph();
        this.delayMatrix = new DelayMatrix();
    }

    public BriteNetworkTopology(String filePath) {
        this(ResourceLoader.newInputStreamReader(filePath));
        LOGGER.info("Topology file: {}", (Object)filePath);
    }

    private BriteNetworkTopology(InputStreamReader reader) {
        this();
        TopologyReaderBrite instance = new TopologyReaderBrite();
        this.graph = instance.readGraphFile(reader);
        this.generateMatrices();
    }

    private void generateMatrices() {
        this.delayMatrix = new DelayMatrix(this.getTopologicalGraph(), false);
        this.bwMatrix = this.createBwMatrix(this.getTopologicalGraph(), false);
        this.networkEnabled = true;
    }

    private double[][] createBwMatrix(TopologicalGraph graph, boolean directed) {
        int nodes = graph.getNumberOfNodes();
        double[][] matrix = Util.newSquareMatrix(nodes);
        for (TopologicalLink edge : graph.getLinksList()) {
            matrix[edge.getSrcNodeID()][edge.getDestNodeID()] = edge.getLinkBw();
            if (directed) continue;
            matrix[edge.getDestNodeID()][edge.getSrcNodeID()] = edge.getLinkBw();
        }
        return matrix;
    }

    @Override
    public void addLink(SimEntity src, SimEntity dest, double bandwidth, double latency) {
        if (this.graph == null) {
            this.graph = new TopologicalGraph();
        }
        if (this.entitiesMap == null) {
            this.entitiesMap = new HashMap<SimEntity, Integer>();
        }
        this.addNodeMapping(src);
        this.addNodeMapping(dest);
        this.graph.addLink(new TopologicalLink(this.entitiesMap.get(src), this.entitiesMap.get(dest), latency, bandwidth));
        this.generateMatrices();
    }

    @Override
    public void removeLink(SimEntity src, SimEntity dest) {
        throw new UnsupportedOperationException("Removing links is not yet supported on BriteNetworkTopologies");
    }

    private void addNodeMapping(SimEntity entity) {
        if (this.entitiesMap.putIfAbsent(entity, this.nextIdx) == null) {
            this.graph.addNode(new TopologicalNode(this.nextIdx));
            ++this.nextIdx;
        }
    }

    public void mapNode(SimEntity entity, int briteID) {
        if (!this.networkEnabled) {
            return;
        }
        if (this.entitiesMap.containsKey(entity)) {
            LOGGER.warn("Network mapping: CloudSim entity {} already mapped.", (Object)entity);
            return;
        }
        if (this.entitiesMap.containsValue(briteID)) {
            LOGGER.warn("BRITE node {} already in use.", (Object)briteID);
            return;
        }
        this.entitiesMap.put(entity, briteID);
    }

    public void unmapNode(SimEntity entity) {
        if (!this.networkEnabled) {
            return;
        }
        this.entitiesMap.remove(entity);
    }

    @Override
    public double getDelay(SimEntity src, SimEntity dest) {
        if (!this.networkEnabled) {
            return 0.0;
        }
        try {
            return this.delayMatrix.getDelay(this.entitiesMap.getOrDefault(src, -1), this.entitiesMap.getOrDefault(dest, -1));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 0.0;
        }
    }

    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }

    public TopologicalGraph getTopologicalGraph() {
        return this.graph;
    }

    public double[][] getBwMatrix() {
        return (double[][])Arrays.copyOf(this.bwMatrix, this.bwMatrix.length);
    }
}

