/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cloudbus.cloudsim.resources.File;
import org.cloudbus.cloudsim.resources.HarddriveStorage;
import org.cloudbus.cloudsim.resources.SimpleStorage;

public class SanStorage
extends HarddriveStorage {
    public static final double FILE_NOT_FOUND = -1.0;
    private final SimpleStorage reservedStorage;
    private double bandwidth;
    private double networkLatency;
    private final List<String> fileNameList;
    private final List<File> fileList;

    public SanStorage(long capacity, double bandwidth, double networkLatency) throws IllegalArgumentException {
        this("SanStorage" + capacity, capacity, bandwidth, networkLatency);
    }

    public SanStorage(String name, long capacity, double bandwidth, double networkLatency) {
        super(name, capacity);
        this.setBandwidth(bandwidth);
        this.setNetworkLatency(networkLatency);
        this.fileList = new ArrayList<File>();
        this.fileNameList = new ArrayList<String>();
        this.reservedStorage = new SimpleStorage(capacity);
    }

    public double addReservedFile(File file) {
        Objects.requireNonNull(file);
        if (!this.reservedStorage.isResourceAmountBeingUsed(file.getSize())) {
            throw new IllegalStateException("The file size wasn't previously reserved in order to add a reserved file.");
        }
        long fileSize = file.getSize();
        this.getStorage().deallocateResource(fileSize);
        this.reservedStorage.deallocateResource(fileSize);
        double time = this.addFile(file);
        if (time == 0.0) {
            this.getStorage().allocateResource(fileSize);
            return time;
        }
        return time + this.getTransferTime(file);
    }

    public double addFile(List<File> list) {
        Objects.requireNonNull(list);
        if (list.isEmpty()) {
            LOGGER.debug("{}.addFile(): File list is empty.", (Object)this.getName());
            return 0.0;
        }
        return list.stream().mapToDouble(this::addFile).sum();
    }

    public double addFile(File file) {
        double time = 0.0;
        File.validate(file);
        if (!this.getStorage().isAmountAvailable(file.getSize())) {
            LOGGER.error("{}.addFile(): Not enough space to store {}", (Object)this.getName(), (Object)file.getName());
        } else if (!this.contains(file.getName())) {
            this.fileList.add(file);
            this.fileNameList.add(file.getName());
            this.getStorage().allocateResource(file.getSize());
            time = this.getTotalFileAddTime(file);
            file.setTransactionTime(time);
        }
        if (time == 0.0) {
            return time;
        }
        return time + this.getTransferTime(file);
    }

    public double getBandwidth() {
        return this.bandwidth;
    }

    public final void setBandwidth(double bandwidth) {
        if (bandwidth <= 0.0) {
            throw new IllegalArgumentException("Bandwidth must be higher than zero");
        }
        this.bandwidth = bandwidth;
    }

    public double getNetworkLatency() {
        return this.networkLatency;
    }

    public final void setNetworkLatency(double networkLatency) {
        if (networkLatency <= 0.0) {
            throw new IllegalArgumentException("Latency must be higher than zero");
        }
        this.networkLatency = networkLatency;
    }

    public String toString() {
        return this.getName();
    }

    public int getNumStoredFile() {
        return this.fileList.size();
    }

    public boolean reserveSpace(int fileSize) {
        if (this.getStorage().allocateResource(fileSize)) {
            this.reservedStorage.allocateResource(fileSize);
            return true;
        }
        return false;
    }

    public boolean hasPotentialAvailableSpace(long fileSize) {
        if (fileSize <= 0L) {
            return false;
        }
        if (this.getStorage().isAmountAvailable(fileSize)) {
            return true;
        }
        return (long)this.getDeletedFilesTotalSize() > fileSize;
    }

    public boolean hasFile(String fileName) {
        return this.getFile(fileName).isPresent();
    }

    private int getDeletedFilesTotalSize() {
        return this.fileList.stream().filter(File::isDeleted).mapToInt(File::getSize).sum();
    }

    public Optional<File> getFile(String fileName) {
        File.validateFileName(fileName);
        int size = 0;
        for (File currentFile : this.fileList) {
            size += currentFile.getSize();
            if (!currentFile.getName().equals(fileName)) continue;
            double seekTime = this.getSeekTime(size);
            double transferTime = this.getTransferTime(currentFile.getSize());
            currentFile.setTransactionTime(seekTime + transferTime);
            return Optional.of(currentFile);
        }
        return Optional.empty();
    }

    public List<String> getFileNameList() {
        return Collections.unmodifiableList(this.fileNameList);
    }

    public List<File> getFileList() {
        return Collections.unmodifiableList(this.fileList);
    }

    public double getTransferTime(File file) {
        return this.getTransferTime(file.getSize());
    }

    @Override
    public double getTransferTime(int fileSize) {
        double storageDeviceReadTime = super.getTransferTime(fileSize);
        double networkTransferTime = this.getTransferTime(fileSize, this.bandwidth);
        return storageDeviceReadTime + networkTransferTime + this.getNetworkLatency();
    }

    public double getTransferTime(String fileName) {
        return this.getFile(fileName).map(this::getTransferTime).orElse(-1.0);
    }

    private double getTotalFileAddTime(File file) {
        double seekTime = this.getSeekTime(file.getSize());
        double transferTime = this.getTransferTime(file.getSize());
        return seekTime + transferTime;
    }

    public Optional<File> deleteFile(String fileName) {
        File.validateFileName(fileName);
        int index = this.fileNameList.indexOf(fileName);
        if (index != -1) {
            File file = this.fileList.get(index);
            double result = this.deleteFile(file);
            file.setTransactionTime(result);
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public double deleteFile(File file) {
        File.validate(file);
        double time = 0.0;
        if (this.contains(file)) {
            this.fileList.remove(file);
            this.fileNameList.remove(file.getName());
            this.getStorage().deallocateResource(file.getSize());
            time = this.getTotalFileAddTime(file);
            file.setTransactionTime(time);
        }
        if (time == 0.0) {
            return time;
        }
        return time + this.getTransferTime(file);
    }

    public boolean contains(File file) {
        return file != null && this.contains(file.getName());
    }

    public boolean contains(String fileName) {
        return this.fileNameList.contains(fileName);
    }

    public boolean renameFile(File file, String newName) {
        if (this.contains(newName)) {
            return false;
        }
        String oldName = file.getName();
        return this.getFile(oldName).map(fileFound -> {
            fileFound.setName(newName);
            fileFound.setTransactionTime(0.0);
            this.fileNameList.remove(oldName);
            this.fileNameList.add(newName);
            return fileFound;
        }).isPresent();
    }
}

