/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers;

import org.cloudbus.cloudsim.resources.Processor;

public class MipsShare {
    public static final MipsShare NULL = new MipsShare();
    private long pes;
    private double mips;

    public MipsShare() {
        this(0L, 0.0);
    }

    public MipsShare(double mips) {
        this(1L, mips);
    }

    public MipsShare(Processor processor) {
        this(processor.getCapacity(), processor.getMips());
    }

    public MipsShare(long pes, double mips) {
        if (pes < 0L) {
            throw new IllegalArgumentException("PEs number cannot be negative.");
        }
        this.pes = pes;
        this.setMips(mips);
    }

    public MipsShare(MipsShare share) {
        this(share.pes, share.mips);
    }

    public double mips() {
        return this.mips;
    }

    public final void setMips(double mips) {
        if (mips < 0.0) {
            throw new IllegalArgumentException("MIPS cannot be negative.");
        }
        this.mips = mips;
    }

    public long pes() {
        return this.pes;
    }

    public boolean isEmpty() {
        return this.pes == 0L || this.mips == 0.0;
    }

    public double totalMips() {
        return (double)this.pes * this.mips;
    }

    public long remove(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("The number of PEs to remove cannot be negative.");
        }
        long removedPes = Math.min(count, this.pes);
        this.pes -= removedPes;
        return count;
    }

    public String toString() {
        return "MipsShare{pes=" + this.pes + ", mips=" + this.mips + "}";
    }
}

