/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.schedulers.vm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.schedulers.MipsShare;
import org.cloudbus.cloudsim.schedulers.vm.VmSchedulerAbstract;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmSimple;

public class VmSchedulerSpaceShared
extends VmSchedulerAbstract {
    public VmSchedulerSpaceShared() {
        this(0.1);
    }

    public VmSchedulerSpaceShared(double vmMigrationCpuOverhead) {
        super(vmMigrationCpuOverhead);
    }

    @Override
    protected boolean isSuitableForVmInternal(Vm vm, MipsShare requestedMips) {
        List<Pe> selectedPes = this.getTotalCapacityToBeAllocatedToVm(requestedMips);
        return (long)selectedPes.size() >= requestedMips.pes();
    }

    private List<Pe> getTotalCapacityToBeAllocatedToVm(MipsShare requestedMips) {
        if ((long)this.getHost().getWorkingPesNumber() < requestedMips.pes()) {
            return this.getHost().getWorkingPeList();
        }
        List<Pe> freePeList = this.getHost().getFreePeList();
        ArrayList<Pe> selectedPes = new ArrayList<Pe>();
        if (freePeList.isEmpty()) {
            return selectedPes;
        }
        Iterator<Pe> peIterator = freePeList.iterator();
        Pe pe = peIterator.next();
        int i = 0;
        while ((long)i < requestedMips.pes()) {
            if (requestedMips.mips() <= (double)pe.getCapacity()) {
                selectedPes.add(pe);
                if (!peIterator.hasNext()) break;
                pe = peIterator.next();
            }
            ++i;
        }
        return selectedPes;
    }

    @Override
    public boolean allocatePesForVmInternal(Vm vm, MipsShare requestedMips) {
        List<Pe> selectedPes = this.getTotalCapacityToBeAllocatedToVm(requestedMips);
        if ((long)selectedPes.size() < requestedMips.pes()) {
            return false;
        }
        ((VmSimple)vm).setAllocatedMips(requestedMips);
        return true;
    }

    @Override
    protected long deallocatePesFromVmInternal(Vm vm, int pesToRemove) {
        return this.removePesFromVm(vm, ((VmSimple)vm).getAllocatedMips(), pesToRemove);
    }
}

