/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.selectionpolicies;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.selectionpolicies.VmSelectionPolicy;
import org.cloudbus.cloudsim.vms.Vm;

public class VmSelectionPolicyMinimumUtilization
implements VmSelectionPolicy {
    @Override
    public Optional<Vm> getVmToMigrate(Host host) {
        List<Vm> migratableVms = host.getMigratableVms();
        if (migratableVms.isEmpty()) {
            return Optional.empty();
        }
        Predicate<Vm> inMigration = Vm::isInMigration;
        Comparator<Vm> vmCpuUsageComparator = Comparator.comparingDouble(Vm::getCpuPercentUtilization);
        return migratableVms.stream().filter(inMigration.negate()).min(vmCpuUsageComparator);
    }
}

