/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

public final class BytesConversion {
    public static final double KILO = 1024.0;
    public static final double MEGA = 1048576.0;
    public static final double GIGA = 1.073741824E9;
    public static final double TERA = 1.099511627776E12;

    private BytesConversion() {
    }

    public static double bytesToMegaBytes(double bytes) {
        return bytes / 1048576.0;
    }

    public static double bytesToGigaBytes(double bytes) {
        return bytes / 1.073741824E9;
    }

    public static double bytesToKiloBytes(double bytes) {
        return bytes / 1024.0;
    }

    public static String bytesToStr(double bytes) {
        if (bytes < 1024.0) {
            return String.format("%.0f bytes", bytes);
        }
        if (bytes < 1048576.0) {
            return String.format("%.1f KB", BytesConversion.bytesToKiloBytes(bytes));
        }
        if (bytes < 1.073741824E9) {
            return String.format("%.1f MB", BytesConversion.bytesToMegaBytes(bytes));
        }
        return String.format("%.1f GB", BytesConversion.bytesToGigaBytes(bytes));
    }

    public static double bytesToMegaBits(double bytes) {
        return BytesConversion.bytesToBits(BytesConversion.bytesToMegaBytes(bytes));
    }

    public static double bytesToBits(double bytes) {
        return bytes * 8.0;
    }

    public static double bitesToBytes(double bits) {
        return bits / 8.0;
    }

    public static double megaBytesToBytes(double megaBytes) {
        return megaBytes * 1048576.0;
    }

    public static double megaToGiga(double mega) {
        return mega / 1024.0;
    }

    public static double megaToTera(double mega) {
        return mega / 1048576.0;
    }

    public static double gigaToMega(double giga) {
        return giga * 1024.0;
    }

    public static double teraToMega(double tera) {
        return BytesConversion.teraToGiga(tera) * 1024.0;
    }

    public static double teraToGiga(double tera) {
        return tera * 1024.0;
    }
}

