/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public final class MathUtil {
    private MathUtil() {
    }

    public static double sum(List<? extends Number> list) {
        double sum = 0.0;
        for (Number number : list) {
            sum += number.doubleValue();
        }
        return sum;
    }

    public static double median(Collection<Double> list) {
        return MathUtil.getStatistics(list).getPercentile(50.0);
    }

    public static double median(double ... list) {
        return MathUtil.getStatistics(list).getPercentile(50.0);
    }

    public static DescriptiveStatistics getStatistics(Collection<Double> list) {
        DescriptiveStatistics stats = new DescriptiveStatistics();
        list.forEach(arg_0 -> ((DescriptiveStatistics)stats).addValue(arg_0));
        return stats;
    }

    public static DescriptiveStatistics getStatistics(double ... list) {
        return new DescriptiveStatistics(list);
    }

    public static double mean(List<Double> list) {
        if (list.isEmpty()) {
            return 0.0;
        }
        return MathUtil.sum(list) / (double)list.size();
    }

    public static double variance(List<Double> list) {
        long count = 0L;
        double mean = MathUtil.mean(list);
        double deltaSum = 0.0;
        for (double x : list) {
            double delta = x - mean;
            deltaSum += delta * (x - (mean += delta / (double)(++count)));
        }
        return deltaSum / (double)(count - 1L);
    }

    public static double stDev(List<Double> list) {
        return Math.sqrt(MathUtil.variance(list));
    }

    public static double mad(double ... data) {
        if (data.length == 0) {
            return 0.0;
        }
        double median = MathUtil.median(data);
        double[] deviationSum = new double[data.length];
        for (int i = 0; i < data.length; ++i) {
            deviationSum[i] = Math.abs(median - data[i]);
        }
        return MathUtil.median(deviationSum);
    }

    public static double iqr(double ... data) {
        Arrays.sort(data);
        int quartile1 = (int)Math.round(0.25 * (double)(data.length + 1)) - 1;
        int quartile3 = (int)Math.round(0.75 * (double)(data.length + 1)) - 1;
        return data[quartile3] - data[quartile1];
    }

    public static int countNonZeroBeginning(double ... data) {
        int index = data.length - 1;
        while (index >= 0 && data[index--] == 0.0) {
        }
        return index + 2;
    }

    public static double[] abs(double ... data) {
        double[] result = new double[data.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.abs(data[i]);
        }
        return result;
    }

    public static int doubleToInt(double value) {
        return (int)(value < 0.0 ? Math.floor(value) : Math.ceil(value));
    }

    public static int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean same(double first, double second) {
        return MathUtil.same(first, second, 0.01);
    }

    public static boolean same(double first, double second, double precisionError) {
        return Math.abs(first - second) <= precisionError;
    }

    public static double percent(double partial, double total) {
        return partial / total * 100.0;
    }

    public static long positive(long first, long second) {
        return first > 0L ? first : second;
    }

    public static double positive(double first, double second) {
        return first > 0.0 ? first : second;
    }
}

