/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.util;

public final class PowerConversion {
    private static final double KILO = 1000.0;
    private static final double MEGA = 1000000.0;
    private static final double GIGA = 1.0E9;
    private static final double TERA = 1.0E12;

    private PowerConversion() {
    }

    public static double wattSecondsToKWattHours(double power) {
        return power * 1000.0 / 3600.0;
    }

    public static double wattsToKilo(double watts) {
        return watts / 1000.0;
    }

    public static double wattsToMega(double watts) {
        return watts / 1000000.0;
    }

    public static double wattsToGiga(double watts) {
        return watts / 1.0E9;
    }

    public static double wattsToTera(double watts) {
        return watts / 1.0E12;
    }

    public static double megaToGiga(double mega) {
        return mega / 1000.0;
    }

    public static double megaToTera(double mega) {
        return mega / 1000000.0;
    }

    public static double gigaToMega(double giga) {
        return giga * 1000.0;
    }

    public static double teraToMega(double tera) {
        return PowerConversion.teraToGiga(tera) * 1000.0;
    }

    public static double teraToGiga(double tera) {
        return tera * 1000.0;
    }
}

