/*
 * Decompiled with CFR 0.152.
 */
package org.cloudbus.cloudsim.vms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.AbstractMachine;
import org.cloudbus.cloudsim.core.CustomerEntityAbstract;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.resources.Bandwidth;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.Ram;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.resources.SimpleStorage;
import org.cloudbus.cloudsim.schedulers.MipsShare;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletScheduler;
import org.cloudbus.cloudsim.schedulers.cloudlet.CloudletSchedulerTimeShared;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudbus.cloudsim.vms.VmGroup;
import org.cloudbus.cloudsim.vms.VmResourceStats;
import org.cloudbus.cloudsim.vms.VmStateHistoryEntry;
import org.cloudsimplus.autoscaling.HorizontalVmScaling;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.VmScaling;
import org.cloudsimplus.listeners.EventListener;
import org.cloudsimplus.listeners.VmDatacenterEventInfo;
import org.cloudsimplus.listeners.VmHostEventInfo;

public class VmSimple
extends CustomerEntityAbstract
implements Vm {
    private static long defaultRamCapacity = 1024L;
    private static long defaultBwCapacity = 100L;
    private static long defaultStorageCapacity = 1024L;
    private VmResourceStats cpuUtilizationStats;
    private final List<VmStateHistoryEntry> stateHistory;
    private HorizontalVmScaling horizontalScaling;
    private boolean failed;
    private final Processor processor;
    private String vmm;
    private CloudletScheduler cloudletScheduler;
    private Host host;
    private boolean inMigration;
    private boolean created;
    private List<ResourceManageable> resources;
    private SimpleStorage storage;
    private Ram ram;
    private Bandwidth bw;
    private long freePesNumber;
    private long expectedFreePesNumber;
    private double submissionDelay;
    private final List<EventListener<VmHostEventInfo>> onMigrationStartListeners;
    private final List<EventListener<VmHostEventInfo>> onMigrationFinishListeners;
    private final List<EventListener<VmHostEventInfo>> onHostAllocationListeners;
    private final List<EventListener<VmHostEventInfo>> onHostDeallocationListeners;
    private final List<EventListener<VmHostEventInfo>> onUpdateProcessingListeners;
    private final List<EventListener<VmDatacenterEventInfo>> onCreationFailureListeners;
    private VerticalVmScaling ramVerticalScaling;
    private VerticalVmScaling bwVerticalScaling;
    private VerticalVmScaling peVerticalScaling;
    private String description;
    private double startTime;
    private double stopTime;
    private double lastBusyTime;
    private VmGroup group;
    private double timeZone;
    private MipsShare allocatedMips;
    private MipsShare requestedMips;

    public VmSimple(Vm sourceVm) {
        this(sourceVm.getMips(), sourceVm.getNumberOfPes());
        this.setBw(sourceVm.getBw().getCapacity()).setRam(sourceVm.getRam().getCapacity()).setSize(sourceVm.getStorage().getCapacity());
    }

    public VmSimple(double mipsCapacity, long numberOfPes) {
        this(-1L, mipsCapacity, numberOfPes);
    }

    public VmSimple(double mipsCapacity, long numberOfPes, CloudletScheduler cloudletScheduler) {
        this(-1L, mipsCapacity, numberOfPes);
        this.setCloudletScheduler(cloudletScheduler);
    }

    public VmSimple(long id, double mipsCapacity, long numberOfPes) {
        this(id, (long)mipsCapacity, numberOfPes);
    }

    public VmSimple(long id, long mipsCapacity, long numberOfPes) {
        this.setId(id);
        this.resources = new ArrayList<ResourceManageable>(4);
        this.onMigrationStartListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onMigrationFinishListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onHostAllocationListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onHostDeallocationListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.onCreationFailureListeners = new ArrayList<EventListener<VmDatacenterEventInfo>>();
        this.onUpdateProcessingListeners = new ArrayList<EventListener<VmHostEventInfo>>();
        this.stateHistory = new LinkedList<VmStateHistoryEntry>();
        this.allocatedMips = new MipsShare();
        this.requestedMips = new MipsShare();
        this.processor = new Processor(this, mipsCapacity, numberOfPes);
        this.setMips(mipsCapacity);
        this.setNumberOfPes(numberOfPes);
        this.mutableAttributesInit();
        this.freePesNumber = numberOfPes;
        this.expectedFreePesNumber = numberOfPes;
    }

    private void mutableAttributesInit() {
        this.description = "";
        this.startTime = -1.0;
        this.stopTime = -1.0;
        this.lastBusyTime = Double.MAX_VALUE;
        this.setBroker(DatacenterBroker.NULL);
        this.setSubmissionDelay(0.0);
        this.setVmm("Xen");
        this.setInMigration(false);
        this.host = Host.NULL;
        this.setCloudletScheduler(new CloudletSchedulerTimeShared());
        this.setHorizontalScaling(HorizontalVmScaling.NULL);
        this.setRamVerticalScaling(VerticalVmScaling.NULL);
        this.setBwVerticalScaling(VerticalVmScaling.NULL);
        this.setPeVerticalScaling(VerticalVmScaling.NULL);
        this.cpuUtilizationStats = VmResourceStats.NULL;
        this.setRam(new Ram(defaultRamCapacity));
        this.setBw(new Bandwidth(defaultBwCapacity));
        this.setStorage(new SimpleStorage(defaultStorageCapacity));
    }

    @Override
    public double updateProcessing(MipsShare mipsShare) {
        return this.updateProcessing(this.getSimulation().clock(), mipsShare);
    }

    @Override
    public double updateProcessing(double currentTime, MipsShare mipsShare) {
        Objects.requireNonNull(mipsShare);
        if (!this.cloudletScheduler.isEmpty()) {
            this.setLastBusyTime();
        }
        double nextSimulationDelay = this.cloudletScheduler.updateProcessing(currentTime, mipsShare);
        this.notifyOnUpdateProcessingListeners();
        this.cpuUtilizationStats.add(currentTime);
        this.getBroker().requestIdleVmDestruction(this);
        if (nextSimulationDelay == Double.MAX_VALUE) {
            return nextSimulationDelay;
        }
        double decimals = currentTime - (double)((int)currentTime);
        return nextSimulationDelay - decimals < 0.0 ? nextSimulationDelay : nextSimulationDelay - decimals;
    }

    @Override
    public long getFreePesNumber() {
        return this.freePesNumber;
    }

    public Vm setFreePesNumber(long freePesNumber) {
        if (freePesNumber < 0L) {
            freePesNumber = 0L;
        }
        this.freePesNumber = Math.min(freePesNumber, this.getNumberOfPes());
        return this;
    }

    @Override
    public long getExpectedFreePesNumber() {
        return this.expectedFreePesNumber;
    }

    public Vm addExpectedFreePesNumber(long pesToAdd) {
        return this.setExpectedFreePesNumber(this.expectedFreePesNumber + pesToAdd);
    }

    public Vm removeExpectedFreePesNumber(long pesToRemove) {
        return this.setExpectedFreePesNumber(this.expectedFreePesNumber - pesToRemove);
    }

    private Vm setExpectedFreePesNumber(long expectedFreePes) {
        if (expectedFreePes < 0L) {
            expectedFreePes = 0L;
        }
        this.expectedFreePesNumber = expectedFreePes;
        return this;
    }

    @Override
    public double getCpuPercentUtilization() {
        return this.getCpuPercentUtilization(this.getSimulation().clock());
    }

    @Override
    public double getCpuPercentUtilization(double time) {
        return this.cloudletScheduler.getAllocatedCpuPercent(time);
    }

    @Override
    public double getCpuPercentRequested() {
        return this.getCpuPercentRequested(this.getSimulation().clock());
    }

    @Override
    public double getCpuPercentRequested(double time) {
        return this.cloudletScheduler.getRequestedCpuPercent(time);
    }

    @Override
    public double getHostCpuUtilization(double time) {
        return this.host.getExpectedRelativeCpuUtilization(this, this.getCpuPercentUtilization(time));
    }

    @Override
    public double getExpectedHostCpuUtilization(double vmCpuUtilizationPercent) {
        return this.host.getExpectedRelativeCpuUtilization(this, vmCpuUtilizationPercent);
    }

    @Override
    public double getHostRamUtilization() {
        return this.host.getRelativeRamUtilization(this);
    }

    @Override
    public double getHostBwUtilization() {
        return this.host.getRelativeBwUtilization(this);
    }

    @Override
    public double getTotalCpuMipsUtilization() {
        return this.getTotalCpuMipsUtilization(this.getSimulation().clock());
    }

    @Override
    public double getTotalCpuMipsUtilization(double time) {
        return this.getCpuPercentUtilization(time) * this.getTotalMipsCapacity();
    }

    @Override
    public double getTotalCpuMipsRequested() {
        return this.getCurrentRequestedMips().totalMips();
    }

    @Override
    public MipsShare getCurrentRequestedMips() {
        if (this.isCreated()) {
            return this.host.getVmScheduler().getRequestedMips(this);
        }
        return new MipsShare(this.processor);
    }

    @Override
    public long getCurrentRequestedBw() {
        if (!this.isCreated()) {
            return this.bw.getCapacity();
        }
        return (long)(this.cloudletScheduler.getCurrentRequestedBwPercentUtilization() * (double)this.bw.getCapacity());
    }

    @Override
    public double getTotalMipsCapacity() {
        return this.getMips() * (double)this.getNumberOfPes();
    }

    @Override
    public long getCurrentRequestedRam() {
        if (!this.isCreated()) {
            return this.ram.getCapacity();
        }
        return (long)(this.cloudletScheduler.getCurrentRequestedRamPercentUtilization() * (double)this.ram.getCapacity());
    }

    @Override
    public double getStartTime() {
        return this.startTime;
    }

    @Override
    public Vm setStartTime(double startTime) {
        if (startTime < 0.0) {
            return this;
        }
        this.startTime = startTime;
        this.setLastBusyTime(startTime);
        return this;
    }

    @Override
    public double getStopTime() {
        return this.stopTime;
    }

    @Override
    public Vm setStopTime(double stopTime) {
        this.stopTime = Math.max(stopTime, -1.0);
        return this;
    }

    @Override
    public double getLastBusyTime() {
        return this.lastBusyTime;
    }

    public boolean hasStartedSomeCloudlet() {
        return this.lastBusyTime != Double.MAX_VALUE;
    }

    private void setLastBusyTime() {
        this.lastBusyTime = this.getSimulation().clock();
    }

    private void setLastBusyTime(double time) {
        this.lastBusyTime = time;
    }

    @Override
    public double getTotalExecutionTime() {
        if (this.startTime < 0.0) {
            return 0.0;
        }
        return this.stopTime < 0.0 ? this.getSimulation().clock() - this.startTime : this.stopTime - this.startTime;
    }

    @Override
    public double getMips() {
        return this.processor.getMips();
    }

    protected final void setMips(double mips) {
        this.processor.setMips(mips);
    }

    @Override
    public long getNumberOfPes() {
        return this.processor.getCapacity();
    }

    private void setNumberOfPes(long numberOfPes) {
        this.processor.setCapacity(numberOfPes);
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public ResourceManageable getRam() {
        return this.ram;
    }

    private void setRam(Ram ram) {
        this.ram = Objects.requireNonNull(ram);
    }

    @Override
    public final Vm setRam(long ramCapacity) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("RAM capacity can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setRam(new Ram(ramCapacity));
        return this;
    }

    @Override
    public ResourceManageable getBw() {
        return this.bw;
    }

    private void setBw(Bandwidth bw) {
        this.bw = Objects.requireNonNull(bw);
    }

    @Override
    public final Vm setBw(long bwCapacity) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("Bandwidth capacity can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setBw(new Bandwidth(bwCapacity));
        return this;
    }

    @Override
    public Resource getStorage() {
        return this.storage;
    }

    private void setStorage(SimpleStorage storage) {
        this.storage = Objects.requireNonNull(storage);
    }

    @Override
    public final Vm setSize(long size) {
        if (this.isCreated()) {
            throw new UnsupportedOperationException("Storage size can just be changed when the Vm was not created inside a Host yet.");
        }
        this.setStorage(new SimpleStorage(size));
        return this;
    }

    @Override
    public String getVmm() {
        return this.vmm;
    }

    protected final void setVmm(String vmm) {
        this.vmm = vmm;
    }

    @Override
    public Vm setHost(Host host) {
        if (Host.NULL.equals(Objects.requireNonNull(host))) {
            this.setCreated(false);
        }
        this.host = host;
        return this;
    }

    @Override
    public Host getHost() {
        return this.host;
    }

    @Override
    public CloudletScheduler getCloudletScheduler() {
        return this.cloudletScheduler;
    }

    @Override
    public final Vm setCloudletScheduler(CloudletScheduler cloudletScheduler) {
        Objects.requireNonNull(cloudletScheduler);
        if (this.isCreated()) {
            throw new UnsupportedOperationException("CloudletScheduler can just be changed when the Vm was not created inside a Host yet.");
        }
        this.cloudletScheduler = cloudletScheduler;
        this.cloudletScheduler.setVm(this);
        return this;
    }

    @Override
    public boolean isInMigration() {
        return this.inMigration;
    }

    @Override
    public final void setInMigration(boolean migrating) {
        this.inMigration = migrating;
    }

    public void updateMigrationStartListeners(Host targetHost) {
        for (int i = 0; i < this.onMigrationStartListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onMigrationStartListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this, targetHost));
        }
    }

    public void updateMigrationFinishListeners(Host targetHost) {
        for (int i = 0; i < this.onMigrationFinishListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onMigrationFinishListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this, targetHost));
        }
    }

    @Override
    public final boolean isCreated() {
        return this.created;
    }

    @Override
    public boolean isSuitableForCloudlet(Cloudlet cloudlet) {
        return this.getNumberOfPes() >= cloudlet.getNumberOfPes() && this.storage.getAvailableResource() >= cloudlet.getFileSize();
    }

    @Override
    public void setCreated(boolean created) {
        if (!this.created && created) {
            this.setCreationTime();
        }
        this.created = created;
        this.setFailed(false);
    }

    @Override
    public List<VmStateHistoryEntry> getStateHistory() {
        return Collections.unmodifiableList(this.stateHistory);
    }

    @Override
    public void addStateHistoryEntry(VmStateHistoryEntry entry) {
        VmStateHistoryEntry previousState;
        if (!this.stateHistory.isEmpty() && (previousState = this.stateHistory.get(this.stateHistory.size() - 1)).getTime() == entry.getTime()) {
            this.stateHistory.set(this.stateHistory.size() - 1, entry);
            return;
        }
        this.stateHistory.add(entry);
    }

    @Override
    public List<ResourceManageable> getResources() {
        if (this.getSimulation().isRunning() && this.resources.isEmpty()) {
            this.resources = Arrays.asList(this.ram, this.bw, this.storage, this.processor);
        }
        return Collections.unmodifiableList(this.resources);
    }

    @Override
    public ResourceManageable getResource(Class<? extends ResourceManageable> resourceClass) {
        if (Pe.class.isAssignableFrom(resourceClass) || Processor.class.isAssignableFrom(resourceClass)) {
            return this.processor;
        }
        return Vm.super.getResource(resourceClass);
    }

    @Override
    public Vm addOnHostAllocationListener(EventListener<VmHostEventInfo> listener) {
        this.onHostAllocationListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public Vm addOnMigrationStartListener(EventListener<VmHostEventInfo> listener) {
        this.onMigrationStartListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public Vm addOnMigrationFinishListener(EventListener<VmHostEventInfo> listener) {
        this.onMigrationFinishListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public Vm addOnHostDeallocationListener(EventListener<VmHostEventInfo> listener) {
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onHostDeallocationListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public Vm addOnCreationFailureListener(EventListener<VmDatacenterEventInfo> listener) {
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onCreationFailureListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public Vm addOnUpdateProcessingListener(EventListener<VmHostEventInfo> listener) {
        if (listener.equals(EventListener.NULL)) {
            return this;
        }
        this.onUpdateProcessingListeners.add(Objects.requireNonNull(listener));
        return this;
    }

    @Override
    public boolean removeOnCreationFailureListener(EventListener<VmDatacenterEventInfo> listener) {
        return this.onCreationFailureListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public boolean removeOnUpdateProcessingListener(EventListener<VmHostEventInfo> listener) {
        return this.onUpdateProcessingListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public boolean removeOnHostAllocationListener(EventListener<VmHostEventInfo> listener) {
        return this.onHostAllocationListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public boolean removeOnHostDeallocationListener(EventListener<VmHostEventInfo> listener) {
        return this.onHostDeallocationListeners.remove(Objects.requireNonNull(listener));
    }

    public String toString() {
        String desc = StringUtils.isBlank((CharSequence)this.description) ? "" : String.format(" (%s)", this.description);
        String type = this instanceof VmGroup ? "VmGroup" : "Vm";
        return String.format("%s %d%s", type, this.getId(), desc);
    }

    @Override
    public int compareTo(Vm obj) {
        if (this.equals(Objects.requireNonNull(obj))) {
            return 0;
        }
        return Double.compare(this.getTotalMipsCapacity(), obj.getTotalMipsCapacity()) + Long.compare(this.getId(), obj.getId()) + this.getBroker().compareTo(obj.getBroker());
    }

    @Override
    public void setFailed(boolean failed) {
        this.failed = failed;
        if (failed) {
            this.setCloudletsToFailed();
        }
    }

    public void setCloudletsToFailed() {
        this.getBroker().getCloudletWaitingList().stream().filter(cl -> this.equals(cl.getVm())).forEach(cl -> cl.setStatus(Cloudlet.Status.FAILED_RESOURCE_UNAVAILABLE));
    }

    @Override
    public boolean isFailed() {
        return this.failed;
    }

    @Override
    public boolean isWorking() {
        return !this.isFailed();
    }

    @Override
    public double getSubmissionDelay() {
        return this.submissionDelay;
    }

    @Override
    public final void setSubmissionDelay(double submissionDelay) {
        if (submissionDelay < 0.0) {
            return;
        }
        this.submissionDelay = submissionDelay;
    }

    @Override
    public boolean isDelayed() {
        return this.submissionDelay > 0.0;
    }

    @Override
    public void notifyOnHostAllocationListeners() {
        for (int i = 0; i < this.onHostAllocationListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onHostAllocationListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this));
        }
    }

    @Override
    public void notifyOnHostDeallocationListeners(Host deallocatedHost) {
        Objects.requireNonNull(deallocatedHost);
        for (int i = 0; i < this.onHostDeallocationListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onHostDeallocationListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this, deallocatedHost));
        }
    }

    public void notifyOnUpdateProcessingListeners() {
        for (int i = 0; i < this.onUpdateProcessingListeners.size(); ++i) {
            EventListener<VmHostEventInfo> listener = this.onUpdateProcessingListeners.get(i);
            listener.update(VmHostEventInfo.of(listener, this));
        }
    }

    @Override
    public void notifyOnCreationFailureListeners(Datacenter failedDatacenter) {
        Objects.requireNonNull(failedDatacenter);
        for (int i = 0; i < this.onCreationFailureListeners.size(); ++i) {
            EventListener<VmDatacenterEventInfo> listener = this.onCreationFailureListeners.get(i);
            listener.update(VmDatacenterEventInfo.of(listener, this, failedDatacenter));
        }
    }

    @Override
    public boolean removeOnMigrationStartListener(EventListener<VmHostEventInfo> listener) {
        return this.onMigrationStartListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public boolean removeOnMigrationFinishListener(EventListener<VmHostEventInfo> listener) {
        return this.onMigrationFinishListeners.remove(Objects.requireNonNull(listener));
    }

    @Override
    public HorizontalVmScaling getHorizontalScaling() {
        return this.horizontalScaling;
    }

    @Override
    public final Vm setHorizontalScaling(HorizontalVmScaling horizontalScaling) throws IllegalArgumentException {
        this.horizontalScaling = this.validateAndConfigureVmScaling(horizontalScaling);
        return this;
    }

    @Override
    public final Vm setRamVerticalScaling(VerticalVmScaling ramVerticalScaling) throws IllegalArgumentException {
        this.ramVerticalScaling = this.validateAndConfigureVmScaling(ramVerticalScaling);
        return this;
    }

    @Override
    public final Vm setBwVerticalScaling(VerticalVmScaling bwVerticalScaling) throws IllegalArgumentException {
        this.bwVerticalScaling = this.validateAndConfigureVmScaling(bwVerticalScaling);
        return this;
    }

    @Override
    public final Vm setPeVerticalScaling(VerticalVmScaling peVerticalScaling) throws IllegalArgumentException {
        this.peVerticalScaling = this.validateAndConfigureVmScaling(peVerticalScaling);
        return this;
    }

    @Override
    public VerticalVmScaling getRamVerticalScaling() {
        return this.ramVerticalScaling;
    }

    @Override
    public VerticalVmScaling getBwVerticalScaling() {
        return this.bwVerticalScaling;
    }

    @Override
    public VerticalVmScaling getPeVerticalScaling() {
        return this.peVerticalScaling;
    }

    private <T extends VmScaling> T validateAndConfigureVmScaling(T vmScaling) {
        Objects.requireNonNull(vmScaling);
        if (vmScaling.getVm() != null && vmScaling.getVm() != Vm.NULL && vmScaling.getVm() != this) {
            String name = vmScaling.getClass().getSimpleName();
            throw new IllegalArgumentException("The " + name + " given is already linked to a Vm. Each Vm must have its own " + name + " object or none at all. Another " + name + " has to be provided for this Vm.");
        }
        vmScaling.setVm(this);
        this.addOnUpdateProcessingListener(vmScaling::requestUpScalingIfPredicateMatches);
        return vmScaling;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Vm setDescription(String description) {
        this.description = description == null ? "" : description;
        return this;
    }

    @Override
    public VmGroup getGroup() {
        return this.group;
    }

    public void setGroup(VmGroup group) {
        this.group = Objects.requireNonNull(group);
    }

    @Override
    public VmResourceStats getCpuUtilizationStats() {
        return this.cpuUtilizationStats;
    }

    @Override
    public void enableUtilizationStats() {
        if (this.cpuUtilizationStats == null || this.cpuUtilizationStats == VmResourceStats.NULL) {
            this.cpuUtilizationStats = new VmResourceStats(this, vm -> vm.getCpuPercentUtilization(this.getSimulation().clock()));
        }
    }

    public static long getDefaultRamCapacity() {
        return defaultRamCapacity;
    }

    public static void setDefaultRamCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultRamCapacity = defaultCapacity;
    }

    public static long getDefaultBwCapacity() {
        return defaultBwCapacity;
    }

    public static void setDefaultBwCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultBwCapacity = defaultCapacity;
    }

    public static long getDefaultStorageCapacity() {
        return defaultStorageCapacity;
    }

    public static void setDefaultStorageCapacity(long defaultCapacity) {
        AbstractMachine.validateCapacity(defaultCapacity);
        defaultStorageCapacity = defaultCapacity;
    }

    @Override
    public double getTimeZone() {
        return this.timeZone;
    }

    @Override
    public Vm setTimeZone(double timeZone) {
        this.timeZone = this.validateTimeZone(timeZone);
        return this;
    }

    public MipsShare getAllocatedMips() {
        return this.allocatedMips;
    }

    public void setAllocatedMips(MipsShare allocatedMips) {
        this.allocatedMips = Objects.requireNonNull(allocatedMips);
    }

    public MipsShare getRequestedMips() {
        return this.requestedMips;
    }

    public void setRequestedMips(MipsShare requestedMips) {
        this.requestedMips = Objects.requireNonNull(requestedMips);
    }
}

