/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.autoscaling;

import java.util.Objects;
import java.util.function.Function;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudbus.cloudsim.provisioners.ResourceProvisioner;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.resources.Processor;
import org.cloudbus.cloudsim.resources.Resource;
import org.cloudbus.cloudsim.resources.ResourceManageable;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.autoscaling.VerticalVmScaling;
import org.cloudsimplus.autoscaling.VmScalingAbstract;
import org.cloudsimplus.autoscaling.resources.ResourceScaling;
import org.cloudsimplus.listeners.VmHostEventInfo;

public abstract class VerticalVmScalingAbstract
extends VmScalingAbstract
implements VerticalVmScaling {
    private Function<Vm, Double> upperThresholdFunction;
    private Function<Vm, Double> lowerThresholdFunction;
    private ResourceScaling resourceScaling;
    private final Class<? extends ResourceManageable> resourceClassToScale;
    private double scalingFactor;
    private Resource vmResource;

    public VerticalVmScalingAbstract(Class<? extends ResourceManageable> resourceClassToScale, ResourceScaling resourceScaling, double scalingFactor) {
        this.setResourceScaling(resourceScaling);
        this.lowerThresholdFunction = VerticalVmScaling.NULL.getLowerThresholdFunction();
        this.upperThresholdFunction = VerticalVmScaling.NULL.getUpperThresholdFunction();
        this.resourceClassToScale = this.validateResourceClass(resourceClassToScale);
        this.setScalingFactor(scalingFactor);
    }

    private Class<? extends ResourceManageable> validateResourceClass(Class<? extends ResourceManageable> resourceClass) {
        Objects.requireNonNull(resourceClass);
        if (Pe.class.equals(resourceClass)) {
            return Processor.class;
        }
        return resourceClass;
    }

    @Override
    public Function<Vm, Double> getUpperThresholdFunction() {
        return this.upperThresholdFunction;
    }

    @Override
    public final VerticalVmScaling setUpperThresholdFunction(Function<Vm, Double> upperThresholdFunction) {
        this.validateFunctions(this.lowerThresholdFunction, upperThresholdFunction);
        this.upperThresholdFunction = upperThresholdFunction;
        return this;
    }

    @Override
    public final VerticalVmScaling setLowerThresholdFunction(Function<Vm, Double> lowerThresholdFunction) {
        this.validateFunctions(lowerThresholdFunction, this.upperThresholdFunction);
        this.lowerThresholdFunction = lowerThresholdFunction;
        return this;
    }

    private void validateFunctions(Function<Vm, Double> lowerThresholdFunction, Function<Vm, Double> upperThresholdFunction) {
        Objects.requireNonNull(lowerThresholdFunction);
        Objects.requireNonNull(upperThresholdFunction);
        if (upperThresholdFunction.equals(lowerThresholdFunction)) {
            throw new IllegalArgumentException("Lower and Upper utilization threshold functions cannot be equal.");
        }
    }

    @Override
    public Function<Vm, Double> getLowerThresholdFunction() {
        return this.lowerThresholdFunction;
    }

    @Override
    public final VerticalVmScaling setResourceScaling(ResourceScaling resourceScaling) {
        this.resourceScaling = Objects.requireNonNull(resourceScaling);
        return this;
    }

    @Override
    public double getScalingFactor() {
        return this.scalingFactor;
    }

    @Override
    public final VerticalVmScaling setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
        return this;
    }

    @Override
    public Resource getResource() {
        return this.vmResource;
    }

    @Override
    public final boolean requestUpScalingIfPredicateMatches(VmHostEventInfo evt) {
        if (!this.isTimeToCheckPredicate(evt.getTime())) {
            return false;
        }
        boolean requestedScaling = (this.isVmUnderloaded() || this.isVmOverloaded()) && this.requestUpScaling(evt.getTime());
        this.setLastProcessingTime(evt.getTime());
        return requestedScaling;
    }

    @Override
    public Class<? extends ResourceManageable> getResourceClass() {
        return this.resourceClassToScale;
    }

    @Override
    public long getAllocatedResource() {
        return this.getResource().getAllocatedResource();
    }

    @Override
    public Function<Vm, Double> getResourceUsageThresholdFunction() {
        if (this.isVmUnderloaded()) {
            return this.lowerThresholdFunction;
        }
        if (this.isVmOverloaded()) {
            return this.upperThresholdFunction;
        }
        return vm -> 0.0;
    }

    @Override
    public double getResourceAmountToScale() {
        return Math.ceil(this.resourceScaling.getResourceAmountToScale(this));
    }

    @Override
    protected boolean requestUpScaling(double time) {
        DatacenterBroker broker = this.getVm().getBroker();
        broker.getSimulation().sendNow(broker, broker, CloudSimTag.VM_VERTICAL_SCALING, this);
        return true;
    }

    @Override
    public void setVm(Vm vm) {
        super.setVm(vm);
        this.vmResource = vm.getResource(this.resourceClassToScale);
    }

    private ResourceProvisioner getResourceProvisioner() {
        return this.getVm().getHost().getProvisioner(this.resourceClassToScale);
    }

    private Resource getHostResource() {
        return this.getVm().getHost().getResource(this.resourceClassToScale);
    }

    @Override
    public boolean allocateResourceForVm() {
        if (this.isNotHostResourceAvailable()) {
            return false;
        }
        double newTotalVmResource = (double)this.vmResource.getCapacity() + this.getResourceAmountToScale();
        boolean isAllocated = this.getResourceProvisioner().allocateResourceForVm(this.getVm(), newTotalVmResource);
        if (isAllocated) {
            this.logResourceAllocated();
        } else {
            this.logResourceUnavailable();
        }
        return isAllocated;
    }

    public boolean isNotHostResourceAvailable() {
        return !this.getHostResource().isAmountAvailable(this.getResourceAmountToScale());
    }

    @Override
    public void logResourceUnavailable() {
        Vm vm = this.getVm();
        LOGGER.warn("{}: {}: {} requested more {} of {} capacity but the {} has just {} of available {}", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), vm, (long)this.getResourceAmountToScale(), this.resourceClassToScale.getSimpleName(), vm.getHost(), this.getHostResource().getAvailableResource(), this.resourceClassToScale.getSimpleName()});
    }

    private void logResourceAllocated() {
        Vm vm = this.getVm();
        LOGGER.info("{}: {}: {} more {} allocated to {}: new capacity is {}. Current resource usage is {}%", new Object[]{vm.getSimulation().clockStr(), this.getClass().getSimpleName(), (long)this.getResourceAmountToScale(), this.resourceClassToScale.getSimpleName(), vm, this.vmResource.getCapacity(), this.vmResource.getPercentUtilization() * 100.0});
    }
}

