/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.builders.tables;

import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostStateHistoryEntry;
import org.cloudsimplus.builders.tables.TableBuilderAbstract;
import org.cloudsimplus.builders.tables.TableColumn;

public class HostHistoryTableBuilder
extends TableBuilderAbstract<HostStateHistoryEntry> {
    private final Host host;

    public HostHistoryTableBuilder(Host host) {
        super(host.getStateHistory());
        this.host = host;
    }

    @Override
    protected void createTableColumns() {
        TableColumn col = this.getTable().addColumn("Time ").setFormat("%5.0f");
        this.addColumnDataFunction(col, HostStateHistoryEntry::time);
        String format = "%9.0f";
        col = this.getTable().addColumn("Requested").setFormat("%9.0f");
        this.addColumnDataFunction(col, HostStateHistoryEntry::requestedMips);
        col = this.getTable().addColumn("Allocated").setFormat("%9.0f");
        this.addColumnDataFunction(col, HostStateHistoryEntry::allocatedMips);
        col = this.getTable().addColumn("Used").setFormat("%3.0f%%");
        this.addColumnDataFunction(col, history -> history.percentUsage() * 100.0);
        this.addColumnDataFunction(this.getTable().addColumn("Host Active"), HostStateHistoryEntry::active);
        col = this.getTable().addColumn("Host Total MIPS").setFormat("%9.0f");
        this.addColumnDataFunction(col, history -> this.host.getTotalMipsCapacity());
        col = this.getTable().addColumn("Host Total Usage").setFormat("%5.1f%%");
        this.addColumnDataFunction(col, history -> history.allocatedMips() / this.host.getTotalMipsCapacity() * 100.0);
    }
}

