/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.faultinjection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cloudbus.cloudsim.brokers.DatacenterBroker;
import org.cloudbus.cloudsim.cloudlets.Cloudlet;
import org.cloudbus.cloudsim.core.AbstractMachine;
import org.cloudbus.cloudsim.core.CloudSimEntity;
import org.cloudbus.cloudsim.core.CloudSimTag;
import org.cloudbus.cloudsim.core.Identifiable;
import org.cloudbus.cloudsim.core.Simulation;
import org.cloudbus.cloudsim.core.events.SimEvent;
import org.cloudbus.cloudsim.datacenters.Datacenter;
import org.cloudbus.cloudsim.distributions.ContinuousDistribution;
import org.cloudbus.cloudsim.distributions.StatisticalDistribution;
import org.cloudbus.cloudsim.distributions.UniformDistr;
import org.cloudbus.cloudsim.hosts.Host;
import org.cloudbus.cloudsim.hosts.HostSimple;
import org.cloudbus.cloudsim.resources.Pe;
import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudbus.cloudsim.vms.Vm;
import org.cloudsimplus.faultinjection.VmCloner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostFaultInjection
extends CloudSimEntity {
    private static final int MAX_VM_RECOVERY_TIME_SECS = 450;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)HostFaultInjection.class.getSimpleName());
    private Host lastFailedHost;
    private int lastFailedPesNumber;
    private Datacenter datacenter;
    private final ContinuousDistribution random;
    private final Map<DatacenterBroker, VmCloner> vmClonerMap;
    private final StatisticalDistribution faultArrivalHoursGenerator;
    private int hostFaultsNumber;
    private final Map<Vm, Double> vmRecoveryTimeSecsMap;
    private final Map<Host, List<Double>> hostFaultsTimeSecsMap;
    private final Map<DatacenterBroker, Integer> vmFaultsByBroker;
    private double maxTimeToFailInHours;

    public HostFaultInjection(Datacenter datacenter) {
        this(datacenter, new UniformDistr());
    }

    public HostFaultInjection(Datacenter datacenter, StatisticalDistribution faultArrivalHoursGenerator) {
        super(datacenter.getSimulation());
        this.setDatacenter(datacenter);
        this.lastFailedHost = Host.NULL;
        this.faultArrivalHoursGenerator = faultArrivalHoursGenerator;
        this.random = new UniformDistr(faultArrivalHoursGenerator.getSeed() + 1L);
        this.vmRecoveryTimeSecsMap = new HashMap<Vm, Double>();
        this.hostFaultsTimeSecsMap = new HashMap<Host, List<Double>>();
        this.vmFaultsByBroker = new HashMap<DatacenterBroker, Integer>();
        this.vmClonerMap = new HashMap<DatacenterBroker, VmCloner>();
        this.maxTimeToFailInHours = Double.MAX_VALUE;
    }

    @Override
    protected void startInternal() {
        this.scheduleFaultInjection();
    }

    private void scheduleFaultInjection() {
        Simulation sim = this.getSimulation();
        Predicate<SimEvent> otherEventsPredicate = evt -> evt.getTag() != CloudSimTag.HOST_FAILURE;
        if (sim.clock() < this.getMaxTimeToFailInSecs() || sim.isThereAnyFutureEvt(otherEventsPredicate)) {
            this.schedule(this, this.getTimeDelayForNextFault(), CloudSimTag.HOST_FAILURE);
        }
    }

    private double getTimeDelayForNextFault() {
        return this.faultArrivalHoursGenerator.sample() * 3600.0;
    }

    @Override
    public void processEvent(SimEvent evt) {
        if (evt.getTag() == CloudSimTag.HOST_FAILURE) {
            this.generateHostFaultAndScheduleNext();
        }
    }

    public void generateHostFault(Host host) {
        this.generateHostFault(host, host.getWorkingPesNumber());
    }

    public void generateHostFault(Host host, int pesFailures) {
        Object msg;
        if (Host.NULL == host) {
            return;
        }
        this.lastFailedHost = host;
        ++this.hostFaultsNumber;
        this.registerHostFaultTime();
        long previousWorkingPes = this.lastFailedHost.getWorkingPesNumber();
        this.lastFailedPesNumber = this.generateHostPesFaults(pesFailures);
        long hostWorkingPes = this.lastFailedHost.getWorkingPesNumber();
        long vmsRequiredPes = this.getWorkingVmsPesCount();
        Object object = msg = this.lastFailedHost.getVmList().isEmpty() ? "" : " | VMs required PEs: " + vmsRequiredPes;
        if (hostWorkingPes > 0L) {
            LOGGER.error("{}: {}: Generated {} PEs failures in {} at {}.{}\t  Previous working PEs: {} | Current Working PEs: {} | Current VMs: {}{}", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), this.lastFailedPesNumber, this.lastFailedHost, this.getTime(), System.lineSeparator(), previousWorkingPes, hostWorkingPes, this.lastFailedHost.getVmList().size(), msg});
        }
        if (hostWorkingPes == 0L) {
            this.setAllVmsToFailed();
        } else if (hostWorkingPes >= vmsRequiredPes) {
            this.logNoVmFault();
        } else {
            this.deallocateFailedHostPesFromVms();
        }
    }

    private String getTime() {
        return TimeUtil.secondsToStr(this.getSimulation().clock());
    }

    private void generateHostFaultAndScheduleNext() {
        try {
            Host host = this.getRandomHost();
            this.generateHostFault(host, this.randomFailedPesNumber(host));
        }
        finally {
            this.scheduleFaultInjection();
        }
    }

    private void registerHostFaultTime() {
        this.hostFaultsTimeSecsMap.computeIfAbsent(this.lastFailedHost, host -> new ArrayList()).add(this.getSimulation().clock());
    }

    private Host getRandomHost() {
        if (this.datacenter.getHostList().isEmpty()) {
            return Host.NULL;
        }
        int idx = (int)(this.random.sample() * (double)this.datacenter.getHostList().size());
        return this.datacenter.getHost(idx);
    }

    private void setAllVmsToFailed() {
        int vms = this.lastFailedHost.getVmList().size();
        String msg = vms > 0 ? String.format("affecting all its %d VMs", vms) : "but there was no running VM";
        LOGGER.error("{}: {}: All {} PEs from {} failed at {}, {}.", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), this.lastFailedHost.getNumberOfPes(), this.lastFailedHost, this.getTime(), msg});
        this.setVmListToFailed(this.lastFailedHost.getVmList());
    }

    private void logNoVmFault() {
        if (this.lastFailedHost.getVmList().isEmpty()) {
            LOGGER.info("There aren't VMs running on the failed Host {}.", (Object)this.lastFailedHost.getId());
            return;
        }
        int vmsRequiredPes = (int)this.getWorkingVmsPesCount();
        LOGGER.info("{}: {}: Number of failed PEs in Host {} is smaller than working ones required by all VMs, not affecting any VM.{}\t  Total PEs: {} | Total Failed PEs: {} | Working PEs: {} | Current PEs required by VMs: {}.", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), this.lastFailedHost.getId(), System.lineSeparator(), this.lastFailedHost.getNumberOfPes(), this.lastFailedHost.getFailedPesNumber(), this.lastFailedHost.getWorkingPesNumber(), vmsRequiredPes});
    }

    private void deallocateFailedHostPesFromVms() {
        this.cyclicallyRemoveFailedHostPesFromVms();
        List<Vm> vmsWithoutPes = this.lastFailedHost.getVmList().stream().filter(vm -> vm.getNumberOfPes() == 0L).collect(Collectors.toList());
        this.setVmListToFailed(vmsWithoutPes);
    }

    private void cyclicallyRemoveFailedHostPesFromVms() {
        int failedPesToRemoveFromVms = this.failedPesToRemoveFromVms();
        List<Vm> vmsWithPes = this.getVmsWithPEsFromFailedHost();
        int affectedVms = Math.min(vmsWithPes.size(), failedPesToRemoveFromVms);
        LOGGER.warn("{} VMs affected from a total of {}. {} PEs are going to be removed from them.", new Object[]{affectedVms, this.lastFailedHost.getVmList().size(), failedPesToRemoveFromVms});
        int idx = 0;
        while (!vmsWithPes.isEmpty() && failedPesToRemoveFromVms > 0) {
            --failedPesToRemoveFromVms;
            Vm vm = vmsWithPes.get(idx %= vmsWithPes.size());
            this.lastFailedHost.getVmScheduler().deallocatePesFromVm(vm, 1);
            vm.getCloudletScheduler().deallocatePesFromVm(1L);
            vm.getProcessor().deallocateAndRemoveResource(1L);
            LOGGER.warn("Removing 1 PE from VM {} due to Host PE failure. New VM PEs Number: {}", (Object)vm.getId(), (Object)vm.getNumberOfPes());
            ++idx;
            vmsWithPes = this.getVmsWithPEsFromFailedHost();
        }
    }

    private int failedPesToRemoveFromVms() {
        int hostWorkingPes = this.lastFailedHost.getWorkingPesNumber();
        int vmsRequiredPes = (int)this.getWorkingVmsPesCount();
        return vmsRequiredPes - hostWorkingPes;
    }

    private List<Vm> getVmsWithPEsFromFailedHost() {
        return this.lastFailedHost.getVmList().stream().filter(vm -> vm.getNumberOfPes() > 0L).collect(Collectors.toList());
    }

    private void setVmListToFailed(List<Vm> vms) {
        Map<DatacenterBroker, Vm> lastVmFailedByBrokerMap = this.getLastFailedVmByBroker(vms);
        vms.forEach(this::setVmToFailed);
        lastVmFailedByBrokerMap.forEach(this::createVmCloneIfAllVmsDestroyed);
    }

    private Map<DatacenterBroker, Vm> getLastFailedVmByBroker(List<Vm> vmsWithoutPes) {
        Comparator<Vm> vmComparator = Comparator.comparingLong(Identifiable::getId);
        return vmsWithoutPes.stream().collect(Collectors.toMap(Vm::getBroker, Function.identity(), BinaryOperator.maxBy(vmComparator)));
    }

    private void createVmCloneIfAllVmsDestroyed(DatacenterBroker broker, Vm lastVmFailedFromBroker) {
        if (this.isSomeVmWorking(broker)) {
            return;
        }
        if (!this.isVmClonerSet(broker) || this.getVmCloner(broker).isMaxClonesNumberReached()) {
            this.vmRecoveryTimeSecsMap.put(lastVmFailedFromBroker, -this.getSimulation().clock());
        }
        if (!this.isVmClonerSet(broker)) {
            LOGGER.warn("A Vm Cloner was not set for {}. So that VM failure will not be recovered.", (Object)broker);
            return;
        }
        VmCloner cloner = this.getVmCloner(broker);
        if (cloner.isMaxClonesNumberReached()) {
            LOGGER.warn("The maximum allowed number of {} VMs to create has been reached.", (Object)cloner.getMaxClonesNumber());
            return;
        }
        this.registerFaultOfAllVms(broker);
        double recoveryTimeSecs = this.getRandomRecoveryTimeForVmInSecs();
        String time = String.format("%.2f", recoveryTimeSecs / 60.0);
        LOGGER.info("{}: {}: Time to recovery from fault by cloning the last failed VM on {}: {} minutes.", new Object[]{this.getSimulation().clockStr(), this.getClass().getSimpleName(), lastVmFailedFromBroker.getBroker(), time});
        Map.Entry<Vm, List<Cloudlet>> entry = cloner.clone(lastVmFailedFromBroker);
        Vm clonedVm = entry.getKey();
        List<Cloudlet> clonedCloudlets = entry.getValue();
        clonedVm.setSubmissionDelay(recoveryTimeSecs);
        clonedVm.addOnHostAllocationListener(evt -> this.vmRecoveryTimeSecsMap.put(evt.getVm(), recoveryTimeSecs));
        broker.submitVm(clonedVm);
        broker.submitCloudletList(clonedCloudlets, recoveryTimeSecs);
    }

    private void setVmToFailed(Vm vm) {
        if (Host.NULL.equals(this.lastFailedHost)) {
            return;
        }
        vm.setFailed(true);
        DatacenterBroker broker = vm.getBroker();
        if (this.isVmClonerSet(broker) && this.isSomeVmWorking(broker)) {
            LOGGER.info("{}: {}: {} destroyed on {} but not cloned, since there are {} VMs for the broker yet.", new Object[]{this.getSimulation().clockStr(), broker, vm, vm.getHost(), this.getRunningVmsNumber(broker)});
        }
        this.getSimulation().sendNow(broker, this.datacenter, CloudSimTag.VM_DESTROY, vm);
    }

    private void registerFaultOfAllVms(DatacenterBroker broker) {
        this.vmFaultsByBroker.merge(broker, 1, Integer::sum);
    }

    private VmCloner getVmCloner(DatacenterBroker broker) {
        return this.vmClonerMap.getOrDefault(broker, VmCloner.NULL);
    }

    private boolean isSomeVmWorking(DatacenterBroker broker) {
        return broker.getVmExecList().stream().anyMatch(Vm::isWorking);
    }

    private long getRunningVmsNumber(DatacenterBroker broker) {
        return broker.getVmExecList().stream().filter(Vm::isWorking).count();
    }

    private boolean isVmClonerSet(DatacenterBroker broker) {
        return this.vmClonerMap.getOrDefault(broker, VmCloner.NULL) != VmCloner.NULL;
    }

    public double availability() {
        return this.vmFaultsByBroker.keySet().stream().mapToDouble(this::availability).average().orElse(1.0);
    }

    public double availability(DatacenterBroker broker) {
        double mtbf = this.meanTimeBetweenVmFaultsInMinutes(broker);
        if (mtbf == 0.0) {
            return 1.0;
        }
        double mttr = this.meanTimeToRepairVmFaultsInMinutes(broker);
        return mtbf / (mtbf + mttr);
    }

    public int getHostFaultsNumber() {
        return this.hostFaultsNumber;
    }

    public long getTotalFaultsNumber() {
        return this.vmFaultsByBroker.values().stream().mapToLong(v -> v.intValue()).sum();
    }

    public long getTotalFaultsNumber(DatacenterBroker broker) {
        Objects.requireNonNull(broker);
        return this.vmFaultsByBroker.getOrDefault(broker, 0).intValue();
    }

    private double totalVmsRecoveryTimeInMinutes(DatacenterBroker broker) {
        Stream<Double> timeStream = broker == null ? this.vmRecoveryTimeSecsMap.values().stream() : this.vmRecoveryTimeSecsMap.entrySet().stream().filter(entry -> broker.equals(((Vm)entry.getKey()).getBroker())).map(Map.Entry::getValue);
        double recoverySeconds = timeStream.mapToDouble(secs -> secs >= 0.0 ? secs : this.getSimulation().clock() - Math.abs(secs)).sum();
        return TimeUtil.secondsToMinutes(recoverySeconds);
    }

    public double meanTimeBetweenHostFaultsInMinutes() {
        double[] faultTimes = this.hostFaultsTimeSecsMap.values().stream().flatMap(Collection::stream).mapToDouble(time -> time).sorted().toArray();
        if (faultTimes.length == 0) {
            return 0.0;
        }
        double sum = 0.0;
        double previous = faultTimes[0];
        for (double time2 : faultTimes) {
            sum += time2 - previous;
            previous = time2;
        }
        double seconds = sum / (double)faultTimes.length;
        return (long)(seconds / 60.0);
    }

    public double meanTimeBetweenVmFaultsInMinutes() {
        return this.vmFaultsByBroker.keySet().stream().mapToDouble(this::meanTimeBetweenVmFaultsInMinutes).average().orElse(0.0);
    }

    public double meanTimeBetweenVmFaultsInMinutes(DatacenterBroker broker) {
        double faults = this.getTotalFaultsNumber(broker);
        return faults == 0.0 ? 0.0 : this.getSimulation().clockInMinutes() - this.meanTimeToRepairVmFaultsInMinutes(broker);
    }

    public double meanTimeToRepairVmFaultsInMinutes() {
        return this.vmFaultsByBroker.keySet().stream().mapToDouble(this::meanTimeToRepairVmFaultsInMinutes).average().orElse(0.0);
    }

    public double meanTimeToRepairVmFaultsInMinutes(DatacenterBroker broker) {
        double faults = this.getTotalFaultsNumber(broker);
        return faults == 0.0 ? 0.0 : this.totalVmsRecoveryTimeInMinutes(broker) / faults;
    }

    private int generateHostPesFaults(int pesFailures) {
        List<Pe> peList = this.lastFailedHost.getWorkingPeList().stream().limit(pesFailures).collect(Collectors.toList());
        ((HostSimple)this.lastFailedHost).setPeStatus(peList, Pe.Status.FAILED);
        return pesFailures;
    }

    private long getWorkingVmsPesCount() {
        return this.lastFailedHost.getVmList().stream().filter(Vm::isWorking).mapToLong(AbstractMachine::getNumberOfPes).sum();
    }

    private int randomFailedPesNumber(Host host) {
        return (int)(this.random.sample() * (double)host.getWorkingPesNumber()) + 1;
    }

    public Datacenter getDatacenter() {
        return this.datacenter;
    }

    protected final void setDatacenter(Datacenter datacenter) {
        this.datacenter = Objects.requireNonNull(datacenter);
    }

    public void addVmCloner(DatacenterBroker broker, VmCloner cloner) {
        this.vmClonerMap.put(Objects.requireNonNull(broker), Objects.requireNonNull(cloner));
    }

    public Host getLastFailedHost() {
        return this.lastFailedHost;
    }

    public double getRandomRecoveryTimeForVmInSecs() {
        return this.random.sample() * 450.0 + 1.0;
    }

    public double getMaxTimeToFailInHours() {
        return this.maxTimeToFailInHours;
    }

    private double getMaxTimeToFailInSecs() {
        return this.maxTimeToFailInHours * 3600.0;
    }

    public void setMaxTimeToFailInHours(double maxTimeToFailInHours) {
        this.maxTimeToFailInHours = maxTimeToFailInHours;
    }
}

