/*
 * Decompiled with CFR 0.152.
 */
package org.cloudsimplus.traces.google;

import org.cloudbus.cloudsim.util.TimeUtil;
import org.cloudsimplus.traces.google.GoogleTaskEventsTraceReader;
import org.cloudsimplus.traces.google.TraceField;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TaskEventField implements TraceField<GoogleTaskEventsTraceReader>
{
    TIMESTAMP{

        @Override
        public Double getValue(GoogleTaskEventsTraceReader reader) {
            return TimeUtil.microToSeconds(reader.getFieldDoubleValue(this));
        }
    }
    ,
    MISSING_INFO{

        @Override
        public Integer getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldIntValue(this, -1);
        }
    }
    ,
    JOB_ID{

        @Override
        public Long getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldLongValue(this);
        }
    }
    ,
    TASK_INDEX{

        @Override
        public Long getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldLongValue(this);
        }
    }
    ,
    MACHINE_ID{

        @Override
        public Long getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldLongValue(this, -1L);
        }
    }
    ,
    EVENT_TYPE{

        @Override
        public Integer getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldIntValue(this);
        }
    }
    ,
    USERNAME{

        @Override
        public String getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldValue(this);
        }
    }
    ,
    SCHEDULING_CLASS{

        @Override
        public Integer getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldIntValue(this);
        }
    }
    ,
    PRIORITY{

        @Override
        public Integer getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldIntValue(this);
        }
    }
    ,
    RESOURCE_REQUEST_FOR_CPU_CORES{

        @Override
        public Double getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldDoubleValue(this, 0.0);
        }
    }
    ,
    RESOURCE_REQUEST_FOR_RAM{

        @Override
        public Double getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldDoubleValue(this, 0.0);
        }
    }
    ,
    RESOURCE_REQUEST_FOR_LOCAL_DISK_SPACE{

        @Override
        public Double getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldDoubleValue(this, 0.0);
        }
    }
    ,
    DIFFERENT_MACHINE_CONSTRAINT{

        @Override
        public Integer getValue(GoogleTaskEventsTraceReader reader) {
            return reader.getFieldIntValue(this, -1);
        }
    };

}

