/*
 * Decompiled with CFR 0.152.
 */
package org.clulab.discourse.rstparser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.clulab.discourse.rstparser.CorpusStats;
import org.clulab.discourse.rstparser.CorpusStats$;
import org.clulab.discourse.rstparser.DiscourseTree;
import org.clulab.discourse.rstparser.EDUClassifier;
import org.clulab.discourse.rstparser.EDUClassifier$;
import org.clulab.discourse.rstparser.RSTParser;
import org.clulab.discourse.rstparser.RelationClassifier;
import org.clulab.discourse.rstparser.RelationClassifier$;
import org.clulab.discourse.rstparser.StructureClassifier;
import org.clulab.discourse.rstparser.StructureClassifier$;
import org.clulab.processors.Document;
import org.clulab.processors.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.io.StdIn$;

public final class RSTParser$ {
    public static RSTParser$ MODULE$;
    private final Logger logger;
    private final String DEFAULT_CONSTITUENTSYNTAX_MODEL_PATH;
    private final String DEFAULT_DEPENDENCYSYNTAX_MODEL_PATH;

    static {
        new RSTParser$();
    }

    public Logger logger() {
        return this.logger;
    }

    public String DEFAULT_CONSTITUENTSYNTAX_MODEL_PATH() {
        return this.DEFAULT_CONSTITUENTSYNTAX_MODEL_PATH;
    }

    public String DEFAULT_DEPENDENCYSYNTAX_MODEL_PATH() {
        return this.DEFAULT_DEPENDENCYSYNTAX_MODEL_PATH;
    }

    /*
     * WARNING - void declaration
     */
    public RSTParser loadFrom(String path) {
        void var2_2;
        this.logger().debug("Loading RST parsing model from: " + path);
        RSTParser parser = new RSTParser();
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(path);
        Predef$.MODULE$.assert(is != null, (Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find model file ", " in the classpath!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path})));
        BufferedReader reader = new BufferedReader(new InputStreamReader(new GZIPInputStream(is)));
        CorpusStats corpusStats = CorpusStats$.MODULE$.loadFrom(reader);
        EDUClassifier em = EDUClassifier$.MODULE$.loadFrom(reader);
        StructureClassifier sm = StructureClassifier$.MODULE$.loadFrom(reader, corpusStats);
        RelationClassifier rm = RelationClassifier$.MODULE$.loadFrom(reader, corpusStats);
        reader.close();
        parser.eduModel_$eq(em);
        parser.relModel_$eq(rm);
        parser.structModel_$eq(sm);
        this.logger().debug("Done loading model.");
        return var2_2;
    }

    public void shell(RSTParser parser, Processor proc) {
        while (true) {
            Predef$.MODULE$.print((Object)"> ");
            String line = StdIn$.MODULE$.readLine();
            if (line == null || line.trim().length() <= 0) continue;
            Document doc = proc.annotate(line, proc.annotate$default$2());
            DiscourseTree tree = (DiscourseTree)parser.parse(doc, parser.parse$default$2(), parser.parse$default$3())._1();
            Predef$.MODULE$.println((Object)"Discourse tree:");
            Predef$.MODULE$.println((Object)tree);
        }
    }

    private RSTParser$() {
        MODULE$ = this;
        this.logger = LoggerFactory.getLogger(RSTParser.class);
        this.DEFAULT_CONSTITUENTSYNTAX_MODEL_PATH = "org/clulab/discourse/rstparser/model.const.rst.gz";
        this.DEFAULT_DEPENDENCYSYNTAX_MODEL_PATH = "org/clulab/discourse/rstparser/model.dep.rst.gz";
    }
}

